// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14003 $
//  $Date: 2007-04-06 14:24:40 -0400 (Fri, 06 Apr 2007) $
//  $Author: snoeyink $


// Rosetta Headers
#include "water_ns.h"
#include "hbonds_ns.h" // for HBDerivType
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray4D.hh>

// Using
using namespace param;


namespace water {


//lin variables and parameters for water, including
//lin hetero water, water rotamers and water-mediate hydrogen bond
//lin 04/09/2003

//***********************************************************************
//lin  fullatom type of water
//***********************************************************************
int const type_h2o = { 26 };


//***********************************************************************
//lin  weight flags
//***********************************************************************
	// weight when repacking
	// weight when scoring

namespace weight_flags {
	bool Wint_repack_only = { false }; // using int weights and env dep HB
	bool Wint_score_only = { false }; // using int weights and env dep HB
}


//***********************************************************************
//lin  native water (also call hetero water)
//lin  hetero water: water read from pdbfiles are treated as hetero water
//***********************************************************************
int const MAX_H2OATOM = { 400 }; // maximum # of water atoms
	// to get this info into output pdbfiles


namespace water_atoms {
	FArray2D_float h2o_position( 3, MAX_H2OATOM );
	 // atom position of hetero h2o
	int N_h2oatom; // max size of hetero h2o
	FArray1D_string h2o_pdbline( MAX_H2OATOM );
	 // this is a really crude way to get this info into output pdbfiles
}

//***********************************************************************
//lin  water neighbors information
//***********************************************************************
int const MAX_H2O_PER_AA = { 10 }; // maximum # of water atoms
	// neighbor number of hetero h2o
	// neighbor number of explicit h2o


namespace water_neighbors {
	FArray1D_int hetero_water_neighbors( MAX_H2OATOM );
	FArray2D_int explicit_water_neighbors( MAX_H2O_PER_AA, MAX_RES() );
}


//***********************************************************************
//lin  water flags
//***********************************************************************
	// otherwise, use distance-dependent function
	// otherwise, not use
	// the current solvationmodel, this model is
	// under construction!
	// when repacking


namespace water_flags {
	bool use_hetero_h2o = { false }; // use hetero water to calculate energy?
	bool read_hetero_h2o = { false }; // read hetero water or not
	bool use_water_bonus; // if true, use simple bonus function for h2o_hb
	bool use_h2osol; // if true, use water solvation term to modify
	bool use_h2o_hb_env_dep_lin; // true if use environ wieght
	bool h2ohb_angle_check; // if true, use angle constraints for h2o_hb
}

//***********************************************************************
//lin  water placement
//***********************************************************************
	// both only for the five polar residue:
	// Asp,Asn,GLu,Gln,Arg
bool const simple_placement = { true };
 // using simple way to place the water around aa
bool const stat_placement = { false };
 // place postion of water based on the statistical paper


//***********************************************************************
//lin  cutoffs
//***********************************************************************
float const h2o_interaction_dis2_cutoff = { 36.0 };
 // close water distance cutoff
int const hetero_h2oneighbors_cutoff = { 1 };
 // native water neighbor number cutoff
int const buried_h2oneighbors_cutoff = { 1 };
 // water rotamer neighbor number cutoff
float const h2o_solv_dis_cutoff = { 3.5 }; // water solvation distance cutoff
float const water_repulsive_cutoff = { 8.0 };
 // effective interaction distance cutoff
int const neighbors_limit_buried = { 1 }; // cutoff for buried residues
	// the cutoff, thenthe interactions with
	// their waters is not evaluated
float const water_interaction_cutoff = { 124.0 };
 // if two atom are further apart than
float const h2oE_clash_cut = { 1.0 };
 // intra h2o_E cutoff

///jjh offsets for extra DNA water placements
float const specWaterLengthDelta = { 0.10 };
float const specWaterAngleDelta = { 10.0 };
float const specWaterTorsionDelta = { 10.0 };


//***********************************************************************
//lin  distance and angle parameter for water-mediated H-bond
//***********************************************************************

float const h2ohb_low_limit = { 2.6 };
float const h2ohb_high_limit = { 3.6 };
float const water_ang_lowcut = { 90 };
float const water_ang_highcut = { 140 };
float const wat_acc_ang_lowcut = { 100 };
float const wat_acc_ang_highcut = { 160 };
float const wat_don_ang_lowcut = { 120 }; // cutoff for water angle


//***********************************************************************
//lin  water solvation parameter and variables
//***********************************************************************
	// of each atom at each position
float const Wh2o_sol = { 0.0 };
float const Wh2osol_dgfree = { -0.1 };


namespace water_solvation {
	FArray2D_int nh2o_close_to_atm( MAX_ATOM(), MAX_RES() );
	 // the number of neighbor water
}

//***********************************************************************
//lin  statistical water-mediated H-bond energy
//***********************************************************************
int const h2ohb_bins_per_A = { 10 };
int const h2ohb_bincounts = { 11 };


namespace water_hb {


	void
	h2o_hb_initializer( FArray1D_float & h2o_hb )
	{
		//lin  statistical water-mediated H-bond energy
		int i = 0;
		h2o_hb( ++i ) = 0.000000; // 2.6
		h2o_hb( ++i ) = 0.492037; // 2.7
		h2o_hb( ++i ) = 0.945558; // 2.8
		h2o_hb( ++i ) = 1.000000; // 2.9
		h2o_hb( ++i ) = 0.753802; // 3.0
		h2o_hb( ++i ) = 0.450712; // 3.1
		h2o_hb( ++i ) = 0.169369; // 3.2
		h2o_hb( ++i ) = 0.049717; // 3.3
		h2o_hb( ++i ) = 0.012422; // 3.4
		h2o_hb( ++i ) = 0.005486; // 3.5
		h2o_hb( ++i ) = 0.000000; // 3.6
	}


	FArray1D_float const h2o_hb( h2ohb_bincounts, h2o_hb_initializer );
	 // array for water-mediate hydrogen bond
}

	bool use_hbond_potential( false );
  hbonds::HBDerivType water_hbond_deriv_type( hbonds::hbderiv_NONE );
	FArray4D_float water_hbond_deriv( 3, 2, param::MAX_ATOM(), param::MAX_RES());
}
