// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14003 $
//  $Date: 2007-04-06 14:24:40 -0400 (Fri, 06 Apr 2007) $
//  $Author: snoeyink $

#ifndef INCLUDED_water_ns
#define INCLUDED_water_ns

// Rosetta headers
#include "hbonds_ns.h" // for HBDerivType
// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>



namespace water {


//lin variables and parameters for water, including
//lin hetero water, water rotamers and water-mediate hydrogen bond
//lin 04/09/2003

//***********************************************************************
//lin  fullatom type of water
//***********************************************************************
extern int const type_h2o;


//***********************************************************************
//lin  weight flags
//***********************************************************************
	// weight when repacking
	// weight when scoring

namespace weight_flags {
	extern bool Wint_repack_only; // using int weights and env dep HB
	extern bool Wint_score_only; // using int weights and env dep HB
}
using namespace weight_flags;


//***********************************************************************
//lin  native water (also call hetero water)
//lin  hetero water: water read from pdbfiles are treated as hetero water
//***********************************************************************
extern int const MAX_H2OATOM; // maximum # of water atoms
	// to get this info into output pdbfiles


namespace water_atoms {
	extern FArray2D_float h2o_position; // atom position of hetero h2o
	extern int N_h2oatom; // max size of hetero h2o
	extern FArray1D_string h2o_pdbline; // this is a really crude way
}
using namespace water_atoms;

//***********************************************************************
//lin  water neighbors information
//***********************************************************************
extern int const MAX_H2O_PER_AA; // maximum # of water atoms
	// neighbor number of hetero h2o
	// neighbor number of explicit h2o


namespace water_neighbors {
	extern FArray1D_int hetero_water_neighbors;
	extern FArray2D_int explicit_water_neighbors;
}
using namespace water_neighbors;


//***********************************************************************
//lin  water flags
//***********************************************************************
	// otherwise, use distance-dependent function
	// otherwise, not use
	// the current solvationmodel, this model is
	// under construction!
	// when repacking


namespace water_flags {
	extern bool use_hetero_h2o; // use hetero water to calculate energy or not
	extern bool read_hetero_h2o; // read hetero water or not
	extern bool use_water_bonus; // if true, use simple bonus function for h2o_hb
	extern bool use_h2osol; // if true, use water solvation term to modify
	extern bool use_h2o_hb_env_dep_lin; // true if use environ wieght
	extern bool h2ohb_angle_check; // if true, use angle constraints for h2o_hb
}
using namespace water_flags;

//***********************************************************************
//lin  water placement
//***********************************************************************
	// both only for the five polar residue:
	// Asp,Asn,GLu,Gln,Arg
extern bool const simple_placement;
 // using simple way to place the water around aa
extern bool const stat_placement;
 // place position of water based on the statistical paper


//***********************************************************************
//lin  cutoffs
//***********************************************************************
extern float const h2o_interaction_dis2_cutoff; // close water distance cutoff
extern int const hetero_h2oneighbors_cutoff;
 // native water neighbor number cutoff
extern int const buried_h2oneighbors_cutoff;
 // water rotamer neighbor number cutoff
extern float const h2o_solv_dis_cutoff; // water solvation distance cutoff
extern float const water_repulsive_cutoff;
 // effective interaction distance cutoff
extern int const neighbors_limit_buried; // cutoff for buried residues
	// the cutoff, thenthe interactions with
	// their waters is not evaluated
extern float const water_interaction_cutoff;
 // if two atom are further apart than
extern float const h2oE_clash_cut;
 // intra h2o_E cutoff

///jjh offsets for extra DNA water placements
extern float const specWaterLengthDelta;
extern float const specWaterAngleDelta;
extern float const specWaterTorsionDelta;


//***********************************************************************
//lin  distance and angle parameter for water-mediated H-bond
//***********************************************************************
extern float const h2ohb_low_limit;
extern float const h2ohb_high_limit;
extern float const water_ang_lowcut;
extern float const water_ang_highcut;
extern float const wat_acc_ang_lowcut;
extern float const wat_acc_ang_highcut;
extern float const wat_don_ang_lowcut; // cutoff for water angle


//***********************************************************************
//lin  water solvation parameter and variables
//***********************************************************************
	// of each atom at each position
extern float const Wh2o_sol;
extern float const Wh2osol_dgfree;


namespace water_solvation {
	extern FArray2D_int nh2o_close_to_atm; // the number of neighbor water
}
using namespace water_solvation;

//***********************************************************************
//lin  statistical water-mediated H-bond energy
//***********************************************************************
extern int const h2ohb_bins_per_A;
extern int const h2ohb_bincounts;


namespace water_hb {
	extern FArray1D_float const h2o_hb; // array for water-mediate hydrogen bond
}
using namespace water_hb;

///jjh Simple utility class for holding the info necessary to build
///jjh hydrating waters onto DNA bases

class IC_Info{
public:
	std::string name;
	int template_atom_1, template_atom_2, template_atom_3;
	double length, angle, dihedral;

	IC_Info( std::string in_str, int id1, int id2, int id3, double in_length,
			double in_angle, double in_dihedral ) :  name( in_str.substr( 0, 5 ) ),
			template_atom_1( id1 ), template_atom_2( id2 ),
			template_atom_3( id3 ), length( in_length ), angle( in_angle ),
			dihedral( in_dihedral ){};
};


	extern bool use_hbond_potential;
  extern hbonds::HBDerivType water_hbond_deriv_type;
	extern FArray4D_float water_hbond_deriv;
}


#endif
