// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16039 $
//  $Date: 2007-07-15 01:04:19 -0400 (Sun, 15 Jul 2007) $
//  $Author: ashworth $

#ifndef INCLUDED_weights_manager
#define INCLUDED_weights_manager


///jjh This header contains the interface stuff for
///jjh for the packer weights manager.  Casual users
///jjh should only include this file, not packer_weights.h,
///jjh which has the class definition for PackerWeights
///jjh and should only be used if you need direct access to
///jjh the class.  This header is much more lightweight and
///jjh should lead to fewer compilation dependencies.


///jjh TO ADD A NEW SET OF WEIGHTS:
///jjh  1.  Add an id to the enumeration list below
///jjh  2.  In the function InitializePackerWeightsDB()
///jjh      in weights_manager.cc, copy one of the many
///jjh      weights definition sections, put in your own
///jjh      weights, and insert into the map with your id.

namespace weightfile {
	extern bool use_weightfile;
	extern std::string weight_fname;
}

///jjh An enumeration for PackerWeights tags
enum packerweights_id {
	PW_STANDARD,
	PW_FILE_INPUT,
	PW_INTERFACE,
	PW_DNA,
	PW_DNA_noGB,
	PW_OPTE,
	PW_SAVE_PACK,
	PW_SOFT_REP,
	PW_GEN_BORN,
	PW_SOFT_REP_GEN_BORN,
	PW_LIGAND_SOFT_REP_GEN_BORN,
	PW_LIGAND_SOFT_REP,
	PW_LIGAND_GEN_BORN,
	PW_LIGAND,
	PW_DDG_MONOMER,
	PW_BETA_SOFT_REP,
	PW_ALLFOLD_SOFT_REP,
	PW_SOFT_REP_DESIGN,
	PW_SMALL_RADII,
	PW_SMOOTH_ETABLE,
	PW_PKA
};
//gc PW_MONOMER is for monomer protein ddG calculation
///jjh At the moment, these are the only functions that are intended
///jjh to be visible.

///jjh Insert the commonly used sets of packer weights into the map
void InitializePackerWeightsDB();

///jjh Functions to insert and retrieve PackerWeights from the
///jjh Lookup data structure

void StoreCurrentWeights( packerweights_id const & ws_id );
PackerWeights & RetrieveWeights( packerweights_id const & ws_id );
void RetrieveWeightsToCurrent( packerweights_id const & ws_id );

// For setting weights from a file
void ReadWeights( std::string const & weightfile );

//lin packerweights_id from string
packerweights_id packerweights_id_from_string(std::string const & wt_name );

#endif
