#!/bin/csh

##  Initial Author: Nir London (londonir@cs.huji.ac.il)
 
#usage: Fun2Hunt.sh <pdb1> <pdb2> [1]
#input for this script is the pdb id's of two orientations
# if you have conservation data for this run just use Fun2Hunt.sh <pdb1> <pdb2>
# if you do not have conservation data run: Fun2Hunt.sh <pdb1> <pdb2> 1
#output is the results of the FunHunt classification

set pdb1=$1
set pdb2=$2
set nocons=$3

# set the dir in which FunHunt scripts are found: (change this to the location
# on your system)
set FUNHUNTSCRIPTS="./FunHunt"

#create a combined data file.
touch $pdb1.$pdb2.data
cat $pdb1.data >> $pdb1.$pdb2.data
cat $pdb2.data >> $pdb1.$pdb2.data

#classify with or without conservation
if ($nocons) then
echo "No conservation!"
# remove cons column
cat $pdb1.$pdb2.data | awk '{$8=""; print $0}' >! tmp1
\rm $pdb1.$pdb2.data
mv tmp1 $pdb1.$pdb2.data
#normalize the data over all the decoys.
$FUNHUNTSCRIPTS/LocalProcessData.sh $pdb1.$pdb2.data

#run SVM
$FUNHUNTSCRIPTS/mySvm.sh $pdb1.$pdb2 $nocons
endif

if (!($nocons)) then
echo "Using conservation!"
#normalize the data over all the decoys.
$FUNHUNTSCRIPTS/LocalProcessData.sh $pdb1.$pdb2.data

#run SVM
$FUNHUNTSCRIPTS/mySvm.sh $pdb1.$pdb2 $nocons 
endif

#choose the winner
cat $pdb1.$pdb2.data | awk '{print $2}' >! tmp
paste tmp $pdb1.$pdb2.res | sort -k 2 -n | tail -1 > $pdb1.$pdb2.winner
rm -rf tmp

