#!/bin/csh

##  Initial Author: Nir London (londonir@cs.huji.ac.il)

#This script creates the data file needed for the execution of the FunHunt
#classifier.

#usage FunHuntData.sh <pdbid> <label> 
#      pdbid: 4 letter code
#      label: 1/-1 (if you don't know in advance the labeling use same
#             label for both orientations.

#output is a file named pdbid.data which contains the features' values

#Assumptions:
# - results of a local docking run located in dir XXXX (pdb id)
#   which is in the working dir.
# - compiled scorefiles for the run in:
#   ./XXXX/scorefiles/ (specifically the XXXX.sc)
# - The local run prefix was aa

# set the dir in which FunHunt scripts are found: (change this to the location
# on your system)
set FUNHUNTSCRIPTS="./FunHunt/"

#read in parameters
set pdb=$1
set label=$2

# cp $pdb.sc to $pdb/aa
cp $pdb/scorefiles/$pdb.sc $pdb/aa/

# collect the structures that represent the funnel
# tip according to Irms and Isc, and run rosetta in IF mode on them.
# make sure to modify rosetta binary location 
set rosettaBin="./rosetta.release"

cd $pdb/aa/
rm -rf paths.txt $pdb.list funHuntINT.OUT
# verify that the paths in paths.txt point to the rosetta_database location
# all other paths should be local (./)
cp $FUNHUNTSCRIPTS/IFpaths.txt paths.txt
$FUNHUNTSCRIPTS/Irms_defunnel.pl $pdb.sc
set funSize=`cat $pdb.funnel | head -25 | awk '{print $1}' | sort | uniq | wc -l`
# verify that there are no duplicate structures in the funnel (i.e. there are 25 different decoys)
if ($funSize != 25)then
  echo "There is a problem in the decoys representing the funnel there are less than 25 structures."
  exit();
endif

#create a list of the files representing the funnel
cat $pdb.funnel | head -1  | awk '{print $1}' > $pdb.list #this is a dummy 
# structure, rosetta calls the first structure "native" so we lose his name
# this way we have "26" structs of which 25 have a name
cat $pdb.funnel | head -25 | awk '{print $1}' >> $pdb.list

#run rosetta in IFmode to extract uns HB features
$rosettaBin aa $pdb 1 -interface -Wpack_only -ddg_bind_only -intout funHuntINT.OUT -l $pdb.list -decoystats >! analyze_interface.log 
cd ../../

# collect features data
touch $pdb.data
cd $pdb/aa
foreach j ( `head -25 $pdb.funnel | awk '{print $1}'` )
  $FUNHUNTSCRIPTS/extract_params.pl $j >> ../../$pdb.data
end
cd ../../

# label data
awk '{print $0,'$label'}' $pdb.data >! tmpLabel
rm -rf $pdb.data
\mv tmpLabel $pdb.data
