#!/usr/bin/perl

##  Initial Author: Nir London (londonir@cs.huji.ac.il)

#This script creates a list of the 25 decoys that represents
#the funnel created in the local run.

#usage: Irms_defunnel.pl <XXXX.sc>

# The first parameter given is the local run scorefile name
# assumption: the file name is of the form XXXX.sc
# outcome is a file: XXXX.funnel with the 25 decoys representing the funnel.

$fascfile = $ARGV[0];
$pdb = substr($fascfile,0,4);

open (FASC,"$fascfile");

%map = ();
%name = ();
%invMap = ();

#retrieve params from fasc file
while (<FASC>){
  $line = $_;
  if ($line =~ m/decoy/){
    @fasc_comp = split (" ",$line);
    $nam = $fasc_comp[0];
    $irms = $fasc_comp[5];
    $isc = $fasc_comp[6];
    #deals with the case that two structures
    #share the same iSc or iRms
    if (!(exists($invMap{$isc}))){
      $invMap{$isc} = $irms;
    }
    else {
      while (exists($invMap{$isc})){
        $isc = $isc + 0.001;
      }
      $invMap{$isc} = $irms;
    }
    if (!(exists($map{$irms}))) {
      $map{$irms} = $isc;
      $name{$irms} = $nam;
    }
    else {
      while (exists($map{$irms})){
        $irms = $irms + 0.001;
      }
      $invMap{$isc} = $irms;
      $map{$irms} = $isc;
      $name{$irms} = $nam;
    }
  }
}

@irmss = sort {$a <=> $b} keys(%map);
@sums = {};

#slide over the rms axis in a 50 decoys size window.
for ($i=0; $i<(scalar @irmss)-50; $i++) {
  $sum[$i] = 0;
  for ($j=$i; $j<$i+50; $j++) {
    $sum[$i] = $sum[$i] + $map{$irmss[$j]};
  }
}

$min = 0;
$minInd =0;

for ($i=0; $i<(scalar @irmss)-50; $i++) {
  $avg[$i] = $sum[$i] / 50;
  if ($avg[$i] < $min) {
    $min = $avg[$i];
    $minInd = $i;
  }
}

for ($i=$minInd; $i<$minInd+50; $i++){
    push (@topEnergy,$map{$irmss[$i]});
}

@sortedE = sort {$a <=> $b} @topEnergy;

$outfile = "$pdb.funnel";
open (OUT,">$outfile");

#gather statistics, FunHunt doesn't use these at the moment
#could be used as features at the funnel level - or for automatic
#detection for the existence of a funnel.
$minRms = 100;
$maxRms = 0;
$minE = 100;
$maxE = -500;
$maxGap = -1;
$maxGapInd = 0;

for ($i=0; $i<25; $i++){
  if ($i<24){
    if (($sortedE[$i+1]-$sortedE[$i]) > $maxGap){
      $maxGap = ($sortedE[$i+1]-$sortedE[$i]);
      $maxGapInd = $i;
    }
  }
  print OUT "$name{$invMap{$sortedE[$i]}}\t$invMap{$sortedE[$i]}\t$sortedE[$i]\n";
  if ($invMap{$sortedE[$i]} > $maxRms) { $maxRms = $invMap{$sortedE[$i]}; }
  if ($invMap{$sortedE[$i]} < $minRms) { $minRms = $invMap{$sortedE[$i]}; }
  if (($sortedE[$i]) > $maxE) { $maxE = $sortedE[$i]; }
  if (($sortedE[$i]) < $minE) { $minE = $sortedE[$i]; }
}




@sortedVals = sort {$a <=> $b} values(%map);
$top = 10;
$topSum =0;
for ($i=0;$i<$top;$i++){
  $topSum = $topSum + $invMap{$sortedVals[$i]};
}
$topAvg = $topSum/$top;
for ($i=0;$i<$top;$i++){
  $topVar = $topVar+(($invMap{$sortedVals[$i]}-$topAvg) * ($invMap{$sortedVals[$i]}-$topAvg));
}
$topVar = sqrt($topVar);
$width = $maxRms-$minRms;
$height= $maxE- $minE;
$space = $width*$height;

if ($maxGap < 0.1) {
  print $maxGap;
  $maxGapInd = 24;
}

#print  OUT "width: $width\theight: $height\ts: $space\tmaxGapInd: $maxGapInd ";
#printf OUT ("topVar: %.3f\n",$topVar);
#printf OUT ("combined: %.3f\n",$topVar+($width*$height));

close (OUT);
close(FASC);
