#!/bin/csh

##  Initial Author: Nir London (londonir@cs.huji.ac.il) 

# This script takes in as input the name of the data file containing both
# true and false decoys and outputs a datafile which is normalized over these values
# if the input is xxxx.yyyy.data (the output of a wrapper script Fun2Hunt.sh)
# the result file is xxxx.yyyy.data.rel

set i=$1

cat $i | awk '{print $NF}' >! end.$i
cat $i | awk '{$1=""; $2=""; $NF=""; print $0}' >! data.$i
   
echo `cat data.$i | gawk 'BEGIN{n=0}{for (i=1;i<=NF;i++) {total[i]=total[i] + $i;total2[i]=total2[i] + $i*$i};n=n+1;}END{ for (i=1;i<=NF;i++) {average[i]=total[i]/n; average2[i]=average[i]*average[i]; std2[i]=total2[i]/n-average2[i]; std[i] = sqrt(std2[i]); print average[i]} print "break"; for (i=1;i<=NF;i++) {print std[i]" "}}'` | sed 's/break /\n/g' >! $i.avg.std
cat data.$i >> $i.avg.std

cat $i.avg.std | awk 'BEGIN{count=0}{count=count+1; if(count==1) {for (i=1;i<=NF;i++) {avg[i]=$i}} if(count==2) {for (i=1;i<=NF;i++) {std[i]=$i}} if (count>2) {for (i=1;i<=NF;i++) {$i=($i-avg[i])/std[i]} print $0} }' >! data.$i.rel

paste  data.$i.rel end.$i >! $i.rel
rm -rf data.$i.rel 
rm -rf data.$i end.$i 




    
