#!/bin/csh

##  Initial Author: Nir London (londonir@cs.huji.ac.il)

# This is a crude implementaion of the linear SVM classifier 
# The classification is the distance of the feature vector from the hyperplane
# <w,x> - b
# In this script, w and b are hard coded for FunHunt with/without conservation.

set pdb=$1
set nocons=$2

# no conservation
if ($nocons) then
#0.012174366 :: threshold b
#        ncont                d_env             sasa           delta_score       unsat_BB_HB         centroidity
echo "0.297475208042297 -0.713153349454491 0.541926381789658 0.402316245692678 -0.221957194884946 0.298757934945617" >! tmp

cat $pdb.data.rel | awk '{$NF=""; print $0}' >> tmp
cat tmp | awk 'BEGIN{count=0; B=0.012174366}{count=count+1; if(count==1) {for (i=1;i<=NF;i++) {w[i]=$i}} if (count>1) {sum=0; for (i=1;i<=NF;i++) {sum=sum+($i*w[i])} sum=sum-B;print sum} }' > $pdb.res
endif

# with conservation
if (!($nocons)) then
#-0.04234556 :: threshold b
#        ncont                d_env             sasa           delta_score       unsat_BB_HB         avgCon            centroidity
echo "0.30745523104711 -0.759956259787633 0.62500424256759 0.468442338328557 -0.224304520755596 -0.641360663093284 0.238750898039685" >! tmp

cat $pdb.data.rel | awk '{$NF=""; print $0}' >> tmp
cat tmp | awk 'BEGIN{count=0; B=-0.04234556}{count=count+1; if(count==1) {for (i=1;i<=NF;i++) {w[i]=$i}} if (count>1) {sum=0; for (i=1;i<=NF;i++) {sum=sum+($i*w[i])} sum=sum-B;print sum} }' > $pdb.res
endif

rm -rf tmp





