#!/usr/bin/perl

use Math::Trig;
eval 'exec /usr/bin/perl -S $0 ${1+"$@"}'
    if $running_under_some_shell;
# this emulates #! processing on NIH machines.
# (remove #! line above if indigestible)

#eval '$'.$1.'$2;' while $ARGV[0] =~ /^([A-Za-z_0-9]+=)(.*)/ && shift;
## process any FOO=bar switches

#if (native==1) {
#    $1=="ATOM" {res[NR]=$5;x[NR]=$6;y[NR]=$7;z[NR]=$8;total=NR;}
#} else {
$, = ' ';# set output field separator
    $\ = "\n";# set output record separator
    $distance_cutoff = 8; # 5
$sequence_cutoff = 3; # 5
#open(FILE1, "< /users/jack/1e12stuff/output/1e12.dylan");
$triplet_cut = 64.0;
$close_pair = $triplet_cut;
#$close_pair = 25.0;
print "# pdb:",$ARGV[0];
while (<>) {
    ($Fld1,$Fld2,$Fld3,$Fld4,$Fld5,$Fld6,$Fld7,$Fld8,$Fld9) = split(' ',$_,9999);
    if ($Fld1 eq 'ATOM') {
	if (substr($_,16,1) eq ' ') {
	    if (((substr($_,17,3) eq 'ALA') && (substr($_,13,2) eq 'CB')) ||
		((substr($_,17,3) eq 'VAL') && (substr($_,13,2) eq 'CG')) ||
		((substr($_,17,3) eq 'LEU') && (substr($_,13,2) eq 'CD')) ||
		((substr($_,17,3) eq 'ILE') && (substr($_,13,2) eq 'CD')) ||
		((substr($_,17,3) eq 'ILE') && (substr($_,13,3) eq 'CG2')) ||
		((substr($_,17,3) eq 'THR') && (substr($_,13,2) eq 'CG')) ||
		((substr($_,17,3) eq 'MET') && (substr($_,13,2) eq 'CE'))) {
		$count++;
		$atom{$count} = substr($_,6,5) ; #$Fld2;
		$res{$count} = substr($_,22,4) ; #$Fld5/6;
		$x{$count} = substr($_,31,8) ; #$Fld5/6;
		$y{$count} = substr($_,38,8) ; #$Fld5/6;
		$z{$count} = substr($_,46,8) ; #$Fld5/6;
		$total = $count;
	    }
	}
    }
}
$pairs = 0;
$max = 100000;
for ($i = 1; $i< $total; $i++) {
    $min[$i] = $max;
    $min2[$i] = $max;
}
for ($i = 1; $i< $total; $i++) {
#    for ($j = $i+1; $j< $total; $j++) {
    for ($j = 1; $j< $total; $j++) {
	if (abs($res{$i} - $res{$j})>1) {
	    $temp = ($x{$i}-$x{$j})**2 + ($y{$i}-$y{$j})**2 +
		($z{$i}-$z{$j})**2;
	    if ($temp < $triplet_cut) { # find all atoms that could be a part of a triplet
		    $num_neighbors[$i]++;
		    $num_neighbors[$j]++;
		    $neighbor{$i,$num_neighbors[$i]} = $j;
		    $neighbor{$j,$num_neighbors[$j]} = $i;
		    if ($temp < $min2[$i]) {
			if ($temp < $min[$i]) {
			    $min2_atom[$i] = $min_atom[$i];
			    $min_atom[$i] = $atom{$j};
			    $min2[$i] = $min[$i];
			    $min[$i] = $temp;
			}
			else {
			    $min2_atom[$i] = $atom{$j};
			    $min2[$i] = $temp;
			}
		    }

		    $d{$i,$j} = sqrt($temp);
		    $d{$j,$i} = $d{$i,$j} ;
#    print "d",$d{$i,$j},sqrt($temp);
		# add the downstream atom to upstream atom's neighbor list
		    if ($temp < $close_pair) { # make a list of close pairs, to position 3rd around
		    $indices{$pairs,0} = $i;
		    $indices{$pairs,1} = $j;
#print "close",$pairs,$i,$j,$indices{$pairs,0},$d{$i,$j};
		    $pairs++;
# add the pair to the list
		}
	    }
	}
    }
}
for ($i = 1; $i< $total; $i++) {
    if ($min[$i] < $max) {
	print $i,$atom{$i},$min_atom[$i],$min2_atom[$i],sqrt($min[$i]),sqrt($min2[$i]);
    }
}
exit();

# go through list of pairs
for ($p = 0; $p < $pairs; $p++) {
    $i = $indices{$p,0};
    $j = $indices{$p,1};
    $center[0] = ($x{$i} + $x{$j})/2;
    $center[1] = ($y{$i} + $y{$j})/2;
    $center[2] = ($z{$i} + $z{$j})/2;
#    print "pair2",$p,$i,$j;
    $axis[0] = ($x{$j} - $x{$i})/$d{$i,$j};
    $axis[1] = ($y{$j} - $y{$i})/$d{$i,$j};
    $axis[2] = ($z{$j} - $z{$i})/$d{$i,$j};
    for ($s = 0; $s<2; $s++) {
	$z = $indices{$p,$s};
# start finding triplet atoms for these pairs
	for ($n = 1; $n < $num_neighbors[$z]; $n++) {
	    $k = $neighbor{$z,$n};
	    if ($res{$k} != $res{$i} && $res{$k} != $res{$j}) {
		
		$from_cent[0] = $x{$k} - $center[0];
		$from_cent[1] = $y{$k} - $center[1];
		$from_cent[2] = $z{$k} - $center[2];
		$dot = 0;
		for ($c = 0;$c<3;$c++) {
		    $dot += $from_cent[$c]*$from_cent[$c];
		}
		$mag = sqrt($dot);
		$dot = 0;
		for ($c = 0;$c<3;$c++) {
		    $dot += $axis[$c]*$from_cent[$c]/$mag;
		}
		$angle = acos($dot);
		$r[0] = $mag*$dot;
		$r[1] = $mag*sin($angle);
#    print		"triple",$atom{$i},$atom{$j},$atom{$k},$mag,$angle*360/(2*pi),$d{$i,$j},$i,$j,$k,$angle,$d{$i,$k},$d{$j,$k};
		printf "triple %10d%10d%10d%10d%10.3f%10.3f%10.3f%10.3f%10.3f%10.3f%10.3f\n",$p,$atom{$i},$atom{$j},$atom{$k},$mag,$angle*360/(2*pi),$d{$i,$j},$r[0],$r[1],$d{$i,$k},$d{$j,$k};
	    }
	}
    }
}
