#!/usr/bin/perl -w
#
# extract.pl
#
# Extract PDB from a silent mode file and index file.
# Replaces 'reconstruct_PDB_by_index' (which was a Linux x86 only executable)
# with a call to the rosetta executable.

# Variables
our $usage =<<USAGE;

       USAGE: $0 <silent mode file> <decoy index file>
                 [-binary <path to rosetta binary>]

 DESCRIPTION: Extract PDB from a silent mode file and index.
USAGE

# Get options
%opts = &getCommandLineOptions();

# Check for valid number of arguments
if ( $#ARGV != 1 ) {
  print "Incorrect number of arguments: @ARGV\n";
  print $usage;
  exit;
}

# Variables
$rosetta = $opts{binary} if (exists $opts{binary} && $opts{binary});
$rosetta = "../../../rosetta.gcc" if (!$rosetta);
$silent_file = $ARGV[0];
$decoy_index_file = $ARGV[1];
$arguments  = "-refold -score -scorefile $silent_file -nstruct 1 -silent_input -s $silent_file -l $decoy_index_file";
$command = "$rosetta $arguments";


# Check for valid arguments
$found_arguments = 1;
if ( ! -e $rosetta ) {
  print "Cannot find executable: $rosetta. " .
        "Have you run RosettaAbinitio/setup.sh?\n";
  $found_arguments = 0;
}
if ( ! -e $silent_file ) {
  print "Cannot find file: $silent_file.\n";
  $found_arguments = 0;
}
if ( ! -e $decoy_index_file ) {
  print "Cannot find decoy index file: $decoy_index_file.\n";
  $found_arguments = 0;
}

# If any arguments are incorrect, quit.
if (! $found_arguments ) {
  print $usage;
  exit;
}

print "Extracting using: $command\n";
system($command);


#
# Subroutines
#

sub getCommandLineOptions {
    use Getopt::Long;
    my $fail = 'FALSE';
 
    # Get arguments.
    my %opts = ();
    &GetOptions (\%opts, "binary=s", "db=s", "verbose");
 
    if (exists $opts{verbose}) {
       $opts{verbose} = 1;
    } 
    if ($fail eq 'TRUE') {
        print STDERR "$usage\n";
        exit -1;
    }
 
    return %opts;
}
