#!/usr/bin/perl -w 
 
## REQUIRED PACKAGES
use FindBin qw($Bin);   ## find directory of this script
use lib "$Bin/../lib";  ## must point to directory where FRAGS.pm resides
use FRAGS;

###############################################################
###############################################################
## This script generates fragment files via the robetta 
## fragment server at http://robetta.bakerlab.org.
##
## You need to be a registered user and have the following
## perl libraries for HTTP requests:
##
## libwww-perl (http://search.cpan.org/search?dist=libwww-perl)
##
##   or
##
## individual modules: HTTP, LWP
## 
##
## THIS SCRIPT IS NOT FOR COMMERCIAL USE!!
##
## If you are a commercial user and would like to make 
## fragment libraries, get a license to use the Rosetta 
## Fragment Selection (NNMAKE) package.
##
###############################################################
###############################################################

my ($fasta, $frags, $code, $chain, $series, $nohoms, $verbose);
my ($outfile, $nstruct, $run_dir, $obj, $decoys);
 

 
## get opts
%opts = &getCommandLineOptions();
$fasta          = $opts{fasta};
$username	= $opts{username};
$series         = $opts{xx};
$run_dir        = $opts{rundir};
$nohoms         = $opts{nohoms};
$verbose        = $opts{verbose};

## defaults
$verbose ||= 0;
$nohoms  ||= 0;
$series  ||= "aa";
$run_dir ||= "./";
$run_dir .= "/" if ($run_dir !~ /\/$/);

## lets get full path to silent file and out_dir
$pwd = `pwd`;
chomp $pwd;
$pwd .= "/" if ($pwd !~ /\/$/);
$fasta = $pwd.$fasta if ($fasta !~ /^\//);
$run_dir = $pwd.$run_dir if ($run_dir !~ /^\//);

## get code and chain from fasta
if ($fasta =~ /\/?([^\/]+)$/) {
  my $fastaname = $1;
  if ($fastaname =~ /^(\w\w\w\w)(\w)\.fasta$/) {
    $code = $1;
    $chain = $2;
  }
}

(defined $code && defined $chain) or
  die "ERROR: cannot extract protein code and chain from fasta file name\n";

(defined $username) or
  die "ERROR: registered username is required to run on server\n";
 
$frags = new FRAGS;
$frags->submit( fasta     => $fasta,
                username  => $username,
                code      => $code.$chain,
                series    => $series,
                out_dir   => $run_dir, verbose => $verbose, nohoms => $nohoms );

# Done!
exit(0);


sub getCommandLineOptions {
    use Getopt::Long;
    my $fail = 'FALSE';

    my $username = getlogin || (getpwuid($<))[0] || "unkown";

    my $usage =<<USAGE;
 
       USAGE: $0 <fasta file>
                 [-username <registered robetta username>]
                 [-rundir <full path to run directory>]
                 [-xx <series id> def: aa]
                 [-nohoms]
                 [-verbose]
 
 DESCRIPTION: Submits a job to the fragment server and gets results.
              The protein code and chain are extracted from the fasta
              file name (4 letter code + 1 letter chain + '.fasta').

USAGE
 
    # Get args
    #
    my %opts = ();
    &GetOptions (\%opts, "username=s", "xx=s", "rundir=s", "nohoms", "verbose");
 
    # Check for legal invocation
    #
    $opts{nohoms} = 1 if exists $opts{nohoms};
    $opts{verbose} = 1 if exists $opts{verbose};
    $opts{username} ||= $username;

    if ($opts{xx} && $opts{xx} !~ /^\w\w$/) {
         $fail = 'TRUE';
    }

    (scalar@ARGV) or $fail = 'TRUE';
    $opts{fasta} = shift @ARGV;
    if (!$opts{fasta} || !-s $opts{fasta}) {
        $fail = 'TRUE';
    }

    if ($fail eq 'TRUE') {
        print STDERR "$usage\n";
        exit -1;
    }
 
    return %opts;
}
