#!/usr/bin/perl

## REQUIRED PACKAGES
use FindBin qw($Bin);   ## find directory of this script
use lib "$Bin/../lib";  ## must point to directory where RosettaAB.pm resides
 
###########################################
## CONFIGURATION ##########################

## must point to rosetta executable 
my $ROSETTA       = "$Bin/../../../rosetta++/rosetta.gcc";

## must point to rosetta database
my $ROSETTADB     = "$Bin/../../../rosetta_database/";

## must point to make_fragments.pl from local install of NNMAKE package
## or point to make_fragments_from_server.pl to use the robetta fragment server.
## THE ROBETTA FRAGMENT SERVER IS NOT FOR COMMERCIAL USE
my $MAKEFRAGMENTS = undef;
##my $MAKEFRAGMENTS = "$Bin/../../nnmake/make_fragments.pl";

###########################################
###########################################
$| = 1;

use RosettaAB;

my $verbose = 0;
my ($fasta, $fastaname, $code, $chain, $series, $additional_args);
my ($outfile, $nstruct, $out_dir, $obj, $decoys);

$series = "aa";
 
## get opts
%opts = &getCommandLineOptions();
$fasta          = $opts{fasta};
$nstruct        = $opts{nstruct};
$out_dir	= $opts{outdir};
$additional_args = $opts{additional_args};
$verbose = 1 if (exists $opts{verbose} && $opts{verbose});
$additional_args ||= undef;

$ROSETTA = $opts{binary} if (exists $opts{binary} && $opts{binary});
$ROSETTADB = $opts{db} if (exists $opts{db} && $opts{db});

$out_dir ||= "./";
$out_dir .= "/" if ($out_dir !~ /\/$/);

## lets get full path to silent file and out_dir
$pwd = `pwd`;
chomp $pwd;
$pwd .= "/" if ($pwd !~ /\/$/);
$fasta = $pwd.$fasta if ($fasta !~ /^\//);
$out_dir = $pwd.$out_dir if ($out_dir !~ /^\//);

## get code and chain from fasta
if ($fasta =~ /\/?([^\/]+)$/) {
  $fastaname = $1;
  if ($fastaname =~ /^(\w\w\w\w)(\w)\.fasta$/) {
    $code = $1;
    $chain = $2;
  }
}
(defined $code && defined $chain) or
  die "ERROR: cannot extract protein code and chain from fasta file name\n";

## make sure fasta file is in current directory
if (!-s $out_dir.$fastaname) {
  system("cp", $fasta, $out_dir.$fastaname);
}

## initialize RosettaAB object
$obj = new RosettaAB(    code  => $code,
                         chain => $chain,
                         pred_id => $series,
                         executable => $ROSETTA,
                         rosetta_db => $ROSETTADB,
                         make_fragments => $MAKEFRAGMENTS,
                         run_dir       => $out_dir,
                         nstruct        => $nstruct,
                         additional_args => $additional_args,
			 printoutput    => $verbose );

## lets make decoys
$decoys = $obj->execute();

## done
exit(0);



sub getCommandLineOptions {
    use Getopt::Long;
    my $fail = 'FALSE';
    my $usage =<<USAGE;
 
       USAGE: $0 -fasta <fasta file> -nstruct <number of decoys to make>

                 [-outdir <output directory>]
                 [-binary <rosetta binary>]
                 [-db <rosetta database directory>]
                 [-additional_args <additional rosetta arguments>]
                 [-verbose]

 DESCRIPTION: Generates nstruct decoys in a silent mode file.
              The protein code and chain are extracted from the fasta
              file name (4 letter code + 1 letter chain + '.fasta').
              Fasta file must not have non-alphanumeric characters other
              than . and / for make_fragments.pl.
USAGE
 
    # Get args
    #
    my %opts = ();
    &GetOptions (\%opts, "fasta=s", "binary=s", "db=s", "nstruct=i", "additional_args=s", "outdir=s", "verbose");
 
    # Check for legal invocation
    #
    if (!$opts{fasta} || !-s $opts{fasta} || !$opts{nstruct}) {
        $fail = 'TRUE';
    }
    if (exists $opts{verbose}) {
       $opts{verbose} = 1;
    } 
    if ($fail eq 'TRUE') {
        print STDERR "$usage\n";
        exit -1;
    }
 
    return %opts;
}

