#!/usr/bin/perl -w
package Clustering;
###############################################################################
##
## Copyright 2002, University of Washington
##   This document contains private and confidential information and
##   its disclosure does not constitute publication.  All rights are
##   reserved by University of Washington and the Baker Lab
##   except those specifically granted by license.
##
##  Initial Author: Lars Malmstrom, David E. Kim (dekim@u.washington.edu)
##  $Revision: 6156 $
##  $Date: 2005-04-29 04:59:10 -0400 (Fri, 29 Apr 2005) $
##  $Authors: Lars Malmstrom, David Kim $
##
###############################################################################

## REQUIRED PACKAGES
 
use strict;
use Cwd;

###############################################################################
# main
###############################################################################


# Set up CLUSTERING Run!
sub new {
	my $class = shift;
	my %param = ( base_name => 'clustering', @_ );
	my $self = bless{}, ref $class || $class;

	# Check run_dir
	$param{run_dir} ||= cwd();
	($param{run_dir} && -d $param{run_dir}) or die "CLUSTERING ERROR - run_dir ($param{run_dir}) not set: $!\n";
	$param{run_dir} .= '/' if substr($param{run_dir},-1) ne '/'; 

	# Check executable here.
	($param{executable} && -f $param{executable}) or die "CLUSTERING ERROR - executable ($param{executable}) does not exist: $!\n"; 

	# Check base_name
	($param{base_name} && $param{base_name} =~ /^[\w\.]+$/) or die "CLUSTERING ERROR - base_name $param{base_name} is not valid (must be alphanumeric)\n";

	$self->_init(%param);

	return $self;
}

sub _init {
	my ($self, %param) = @_;

        print "\n";
        print "PARAMS:\n";
        print "executable         = $param{executable}\n";
        print "run_dir            = $param{run_dir}\n";
        print "base_name          = $param{base_name}\n";
        print "\n";

	$self->{_executable}	= $param{executable};
	$self->{_run_dir}	= $param{run_dir};
	$self->{_base_name}	= $param{base_name};
	$self->{_nr_homolog}    = 0;
	
	return 1;
}

sub execute {
	my $this = shift;
	my %param = ( @_);
	my($system,$log,$file,$mode);
	$mode = 'no_homologues';
	$mode = 'homologues' if $this->{_nr_homolog} > 0;

	print "Changing run_dir - chdir $this->{_run_dir}\n";
	(chdir $this->{_run_dir}) or die "CLUSTERING ERROR - Cannot chdir $this->{_run_dir}: $!\n";

	# Check infile
	print "Checking target_infile: $this->{_target_infile}\n";
	(-f $this->{_target_infile}) or die "CLUSTERING ERROR - Infile $this->{_target_infile} not found: $!\n";

	my ($i);
	for ($i=0;$i<$this->{_nr_homolog};$i++) {
		if ($this->{homologue_infile}[$i]) {
			print "Checking homolog infile: $this->{_homolog_infile}[$i]\n";
			(-f $this->{_homologue_infile}[$i]) or
				die "CLUSTERING ERROR - Homologue $this->{_homolog_infile}[$i] not found: $!\n";
		}
	}

	if ($mode eq 'homologues' and !$this->{_target_seq}) {
		die "CLUSTERING ERROR - Target sequence not set in homologues mode\n";
	}

 	$file = $this->{_base_name}.".clusterscmd";
	$file .= ".homs" if ($mode eq 'homologues');
	print "Creating clustercmd file: $file\n"; 
 	open CF, ">$file" or die "CLUSTERING ERROR - Cannot open clustercmd file: $!\n";
	print CF "OUTPUT_FILE ./$this->{_base_name}.clusters";
	print CF ".homs" if ($mode eq 'homologues');
	print CF "\nMETHOD RICH\n";
 	print CF "BEGIN_HOMOLOG_ALIGNMENT\n" if $mode eq 'homologues';
 	print CF "TARGET $this->{_target_infile}";
 	print CF " $this->{_target_seq}"; # if $mode eq 'homologues';
 	print CF "\n";
	for ($i=0;$i<$this->{_nr_homolog};$i++) {
 		print CF "HOMOLOG $this->{_homolog_infile}[$i] $this->{_homolog_seq}[$i]\n";
	}
 	print CF "END_HOMOLOG_ALIGNMENT\n" if $mode eq 'homologues';
 	close CF;

	# System call.
	print "Running clustering executable: $this->{_executable}\n";
	$system = "( $this->{_executable} $file ) 2>&1";
	print "SHELL: $system\n";

        open(CMD, "$system |") or die "CLUSTERING ERROR - cannot run clustering executable: $!\n";
        $|=1; # disable output buffering
        while (<CMD>) { print $_; }
        close(CMD);

        ($? >> 8) ? return 0 : return 1;
}

sub add_target {
	my $this = shift;
	my %param = ( @_ );
	print "Adding target\n";
	($param{infile} && -f $param{infile}) or do {
		die "CLUSTERING ERROR - Infile $param{infile} not set in add_target: $!\n";
	};
	if ($param{seq} && $param{seq} !~ /^[A-Za-z\-]+$/) {
		die "CLUSTERING ERROR - Infile sequence $param{seq} not valid in add_target\n";
	}
	print "Infile: $param{infile}\n";
	print "Sequence: $param{seq}\n" if $param{seq};
	$this->{_target_infile} = $param{infile};
	$this->{_target_seq} = uc $param{seq} if $param{seq};
	return 1;
}

sub add_homolog {
	my $this = shift;
	my %param = ( @_ );
	print "Adding homolog\n";
	($param{infile} && -f $param{infile}) or do {
		die "CLUSTERING ERROR - Infile $param{infile} not set in add_homolog: $!\n";
	};
	if (!$param{seq} || $param{seq} !~ /^[A-Za-z\-]+$/) {
		die "CLUSTERING ERROR - Infile sequence $param{seq} not set or not valid in add_homolog\n";
	}
	print "Infile: $param{infile}\n";
	print "Alignment: $param{seq}\n";
	$this->{_homolog_infile}[$this->{_nr_homolog}] = $param{infile};
	$this->{_homolog_seq}[$this->{_nr_homolog}] = uc $param{seq};
	$this->{_nr_homolog}++;
	return 1;
}



1;
