#!/usr/bin/python

## try to organize  the CHISQ info

from phil import *

def Help():
    print '\nUsage: %s <chisq_file> {<p-val-threshold>}\n'%(argv[0])
    print 'Default p-val-threshold is 0.1 / (number of CHISQ lines)\n\n'
    exit()

if len(argv)<=1:
    Help()

file = argv[1]

if len(argv) >2:
    try:
        MAX_P = float( argv[2])
    except:
        Help()
else:
    MAX_P = 0.0
    
#MAX_P = 0.00001
#MAX_P = 0.001

#target_seq = 'TNFTTRQLTELEKEFHFNKYLSRARRVEIAATLELNETQVKIWFQNRRM'

command = 'grep "^CHISQ" '+file

lines = map(string.split, popen(command).readlines())

if not MAX_P:
    MAX_P = 0.1 / len(lines)

log('MAX_P: %f\n'%MAX_P)

pairs = {}
chisq = {}
pval = {}

for line in lines:
    assert len(line) == 10
    p = float(line[9])

    #if p>MAX_P:continue

    f1 = min( line[3], line[4] )
    f2 = max( line[3], line[4] )

    if not pairs.has_key(f1):
        pairs[f1] = []

    if not pairs.has_key(f2):
        pairs[f2] = []
        
    pairs[f1].append(f2)
    pairs[f2].append(f1)

    chisq[ (f1,f2) ] = float(line[7])
    chisq[ (f2,f1) ] = float(line[7])
    pval[ (f1,f2) ] = p
    pval[ (f2,f1) ] = p 

features = pairs.keys()

features.sort()

count = {}
for f in features:
    count[f] = len( pairs[f] )


if 1: ## use fig_dev grapher
    from fig_devel import Graph,Header,Rainbow_colors
    from math import pi,sin,cos,log10

    l = map(lambda x:[int(x[2:]),x], features)
    l.sort()
    features = map(lambda x:x[1], l)


    def XY(f):
        global features
        assert features.count(f)
        n = len(features)
        theta = 2*pi / n
        
        i = features.index( f )
        x = cos(i*theta)
        y = sin(i*theta)
        return [x,y]


    vertices = []
    edges = []
    labels = []
    for f in features:
        xy = XY(f)
        
        vertices.append( xy )
        pos = int(f[2:])
        labels.append( f, xy )

        for f2 in pairs[f]:
            if f2<=f or pval[(f,f2)] > MAX_P: continue
            
            edges.append( [xy, XY(f2), log10( chisq [(f,f2)] )] )

    out = open('junk.fig','w')
    out.write(Header()+Rainbow_colors()+Graph(vertices,edges,[],labels))
    out.close()

if 0:

    for f1 in features:
        for f2 in pairs[f1]:
            for f3 in pairs[f2]:
                if f3 in pairs[f1]:
                    if f1<f2 and f2<f3:
                        print 'triple:',f1,f2,f3
                    


if 0: ## find cliques

    MIN_LENGTH = 3
    show_list = []
    def Show(clique):
        print 'try to show:',clique
        global show_list
        if len(clique)<MIN_LENGTH: return

        subset = 0
        for c in show_list:
            subset = 1
            for f in clique:
                if f not in c:
                    subset = 0
                    break
            if subset:
                break
        if not subset:
            show_list.append( clique)
            print 'SHOW:',len(clique), clique
            
        
    if 1:

        clique = [ features[0] ]
        last_try = clique[0] ## the last extension we tried

        while clique or last_try < features[-1]:
            print 'while:',last_try, clique

            if clique:
                assert last_try >= clique[-1]

            ## try to add a new guy at the end
            new_clique = clique[:]
            for new_f in features:
                if new_f <= last_try:
                    continue
                ok = 1
                for f in clique:
                    if new_f not in pairs[f]:
                        print 'fail:',f,new_f
                        ok = 0
                        break

                if ok: ## success
                    new_clique.append( new_f )
                    break
                
            if new_clique == clique: ## no success
                Show(clique)

                last_try = clique[-1]
                clique = clique[:-1]
            else:
                print 'extend:',new_clique
                clique = new_clique
                last_try = new_f
                
if 0:
    l = map(lambda x:[count[x], x], count.keys())
    l.sort()
    l.reverse()

    for ll in l:
        f1 = ll[1]
        print f1,count[f1]

        l2 = map(lambda x:[count[x], x], pairs[f1] )
        l2.sort()
        l2.reverse()

        for f2 in map(lambda x:x[1],l2):
            if count[f2] <= count[f1]:
                print '---', f2,count[f2]

        print
    

## 



