#!/usr/bin/python

## trees from distances

from phil import *


import string
from glob import glob

def Help():
    print '\nUsage: %s <cst_file_in> <cst_file_out> \n'%(argv[0])
    exit()
if len(argv)<2:
    Help()
cst_file_in = argv[1]
cst_file_out= argv[2]
delta = 1 ## gap size for joining consecutive residue regions
max_seg = 5 ## maximum number of residues in a single feature
infile=  map(string.split,open(cst_file_in,'r').readlines())

infile_sort = map(lambda x: [int(x[3]),x],infile) 
infile_sort.sort()
infile=map(lambda x: x[1],infile_sort)

previous_res=-999
previous_tag='   '
tag_members={}
tag={}

for cst in infile:
    res=int(cst[3])
    if res  <= previous_res + delta and tag_members[previous_tag] < max_seg:
        if res != previous_res:
            tag_members[previous_tag]=tag_members[previous_tag]+1
        tag[res]=previous_tag
    else :
        tag[res]=cst[0]
        tag_members[cst[0]]=1
    
    previous_res=res
    previous_tag=tag[res]

outfile=open(cst_file_out,'w')
for cst in infile:
    res=int(cst[3])
    new_tag=tag[res]
    freq=float(cst[1])/tag_members[new_tag]
    cst[0]=new_tag
    cst[1]=" %4.3f "%freq
    outfile.write(string.join(cst))
    outfile.write('\n')









