#!/usr/bin/python

from phil import *
from barcode_util import *

def Help():
    print '\nUsage: %s <out_file> -n native_file -b barcode.cst file \n'%(argv[0])
    exit()

args = argv[1:]
if len(argv)<1:
    Help()
list_file = argv[1]

NATIVE=0
if args.count('-n'):
    pos = args.index('-n')
    native_file = args[pos+1]
    del args[pos]
    del args[pos]
    NATIVE=1

cst_exist=0
if args.count('-b'):
    pos = args.index('-b')
    cst_file = args[pos+1]
    del args[pos]
    del args[pos]
    cst_exist=1
    
info={}    
if NATIVE:
    info[NATIVE] = Read_file( native_file )
    nat_seq=Get_seq(info[NATIVE])
    nat_torsions=[]
    for i in range(len(nat_seq)):
        nat_torsions.append( info[NATIVE][i+1]['BB'])

cst_list={}
if cst_exist:
    cst_dat=map(string.split,open(cst_file,'r').readlines())
    for cst in cst_dat:
        cres=int(cst[3])
        if cres not in cst_list.keys():
            cst_list[cres]=[]
        cst_list[cres].append((cst[5],cst[6]))
print cst_list

for res in range(len(nat_seq)):
        if cst_exist==1 :
            if res in cst_list.keys():
                print 'junk',res,cst_list[res]
                    
gpout,gpin = popen2('gnuplot')
gpin.write('set nokey\n')
junk_file=list_file[0:4]+'junk.plot'
out = open(junk_file,'w')
for res in range(len(nat_seq)):
    res_torsions= popen("grep ' %s ' %s | grep -v SCORE"%(res+1,list_file)).readlines() 
    print res
    for line in res_torsions:
        words=string.split(line)
#        print line
        out.write(' F%s %f %f \n'%(res+1,float(words[2]),float(words[3])))
out.close()

if cst_exist ==1 :
    res_to_plot=cst_list.keys()
else:
    res_to_plot=range(1,len(nat_seq)+1)

## for res in range(len(nat_seq)):
## for cres in cst_list.keys():
print res_to_plot
for cres in res_to_plot:
        res=cres-1
        print 'Residue: %s'%(res+1)
        command=" "
        for i in range(20):
            command=command+"set nolabel %s \n"%i
        print command    
        gpin.write(command)
        if NATIVE==1:
          command="set label 1 'N' at %s,%s\n"%(nat_torsions[res][0],nat_torsions[res][1])
          print command
        if cst_exist==1 :
            if (res+1) in cst_list.keys():
                num_cst=0
                for cst in cst_list[res+1]:
                    num_cst=num_cst+1
                    command=command + "set label %s 'B' at %s,%s\n"%(num_cst+1,cst_list[res+1][num_cst-1][0],cst_list[res+1][num_cst-1][1])
            print command
        gpin.write(command)
        gpin.write('set title "%s"\n'%(res+1))
        command= 'plot  [-180:180] [-180:180] "<grep F%s %s " u 2:3'%(res+1,junk_file)
#        for i in range(flavor):
#            command=command + ', "< grep F%s%s junk.plot" u 2:3'%(i+1,res)
        command=command + '\n'
        print command
        gpin.write(command)

        gpin.flush()
        raw_input()


