#!/usr/bin/python
from phil import *

def Help():
    print '\nUsage: %s protein_name chain out_file -f fragment_file -n native_file -bin_width width of bins in degrees \n\n'\
          %(argv[0])

    exit()


if len(argv)<4:
    Help()
args = argv[1:]

frag_exist=0
if args.count('-f'):
    pos = args.index('-f')
    frag_file = args[pos+1]
    frag_exist=1
    del args[pos]
    del args[pos]

BIN_WIDTH=100
if args.count('-bin_width'):
    pos = args.index('-bin_width')
    BIN_WIDTH = int(args[pos+1])
    del args[pos]
    del args[pos]

NATIVE=0
if args.count('-n'):
    pos = args.index('-n')
    native_file = args[pos+1]
    del args[pos]
    del args[pos]
    NATIVE=1

protein=args[0]
chain = args[1]
list_file=args[2]

barcode_script_dir= '~bqian/src/rosetta_scripts/barcode/'
rosetta_dir = '~baker/rosetta++/'


name  = string.split(popen('ls aa%s_0001.pdb '%(protein)).readline())
native_pdb = 'aa%s_0001.pdb'%protein
rosetta_pdb_exist=0
if name != []:
    print name
    print native_file
    if name[0] == native_pdb:
            rosetta_pdb_exist=1

if rosetta_pdb_exist == 0:
    command= rosetta_dir + 'rosetta.intel aa ' + protein + ' ' + chain + ' -score -fa_input -fa_output -nstruct 1 -paths ~baker/rosetta++/paths.txt -s ' + native_file +' >& rosetta_native.log '
    print command
    system(command)

width='%s'%BIN_WIDTH
command= barcode_script_dir + 'residue_flavor_code.py ' + width + ' -l ' + list_file + ' -n ' + native_pdb +' > ' + protein + '.resflavor_log '

print command
system(command)

command = barcode_script_dir + 'resflavor2barcode.pl -log  ' + protein + '.resflavor_log ' + ' -barcode ' + protein + '.bar_code'
#command = 'res_flavor_log2barcode_log.pl -log  flist20 ' +  ' -barcode ' + protein + '.bar_code'
print command
system(command)

command= barcode_script_dir + 'barcode_chisq.py ' + protein + '.bar_code > '+ protein + '.bar_code.chisq'

print command
system(command)


command='grep CHI ' + protein + '.bar_code.chisq | sort -n +7 > ' + protein +'.chisq.list'
print command
system(command)


command = 'grep NAT_DEV '+ protein + '.bar_code | sort -n +4 > ' + protein + '.nat_dev.sort'
print command
system(command)

if (frag_exist):      #not yet debugged!
    command= '%sbarcode_frags.py %s %s %s | sort -n +12 > %s.frag_dev.list'%(barcode_script_dir,list_file,native_pdb,frag_file,protein)
    print command
    system(command)

    frag_ss_dev_list = '%s.frag_dev_ss.list'%protein
    exe = '%sbarcode_frags_ss.py'%(barcode_script_dir)
    command= '%s %s %s %s | sort -n +12 > %s' %(exe,list_file,native_pdb,frag_file,frag_ss_dev_list)
    print command
    system(command)

    command= '%sfrag_ss_dev.py %s  ' %(barcode_script_dir,protein)
    print command
    system(command)
    
    command='%scompare_deviation_lists.py %s'%(barcode_script_dir,protein)
    print command
    system(command)

command='%sbarcode_flavors.py  %s.bar_code %s.bar_code.chisq .0000001 -l %s -n %s -thresh %s > %s.clusters'%(barcode_script_dir,protein,protein,list_file,native_pdb,BIN_WIDTH,protein)
print command
system(command)











