#!/usr/bin/python
# Runs necessary files to reorder the MBPBLA pdb files
# Date: January 11, 2006
# Author: Monica Berrondo
# Command:
# Comments: Creates the loops for MBPBLA including reordering
# and renumbering the sequence.
################################################################

import os
import sys
import string

# Check for necessary arguments
if(len(sys.argv) < 3):
	print 'usage : ' + sys.argv[0] + '<pdbfile with extension> <final chain id>'
	print 'Example: ' + sys.argv[0] + ' 1mba.pdb B'
	sys.exit()

# export the path to nnmake and rosetta++, you need to modify this to match your local paths
os.system('export PATH=$PATH:/home/monica/simcode/nnmake:/home/monica/simcode/rosetta++/')

pdb = sys.argv[1]
final_chains = sys.argv[2]
pdbid = string.split(pdb, '.')[0]
print pdb + ' ' + final_chains + ' ' + pdbid

# create the combined pdb from the pieces in the insertion file
#os.system('cp ~/mbpbla/scripts/paths.txt .')
#os.system('./rosetta.gcc MM ' + pdbid + ' ' + final_chains + ' -domain_insertion -create_fasta -insertion_file insertion_file.prm -l')

# Check for file existence
if(not(os.path.isfile(pdb))):
	print 'File ' + pdb + ' does not exist'
 	sys.exit()

# Back up original pdb file
if(os.path.isfile(pdbid + '.backup')):
	print 'File ' + pdbid + '.backup already exists'
	os.system('cp ' + pdbid + '.backup ' + pdb)
else:
	print 'Backing up original pdb file as ' + pdbid + '.backup'
	os.system('cp ' + pdb + ' ' + pdbid + '.backup')

os.system('cp ' + pdb + ' ' + pdbid + final_chains + '.pdb')

# Making fasta and dssp files
print 'Making fasta file'
os.system('pdb_fasta.pl ' + pdbid + final_chains + '.pdb > ' + pdbid + final_chains +  '.fasta')
os.system('dssp ' + pdb + ' > ' + pdbid + '.dssp')

# Converting dssp file to ssa file
file=open(pdbid + '.dssp', 'r').readlines()
x = ''
for i in range(0,len(file)):
	if file[i][15:18] in [' H ', ' G ']:
		x += 'H'
	if file[i][15:18] in [' E ', ' B ']:
		x += 'E'
	if file[i][13] != '!' and file[i][15:18] in ['   ', ' S ', ' T ', ' L']:
		x += 'L'
x += '\n'
print 'Creating ssa file from dssp'
print x
ssa = open(pdbid + '.ssa', 'w')
ssa.write(x)
ssa.close()

###############################################################
# create the files necessary for make_fragments executable
###############################################################

# ##############################################################
# # making the loop fragments
# ##############################################################

# creates the loop libraries .loops and .loops_all as well as status.200 files
os.system('cp ~/mbpbla/scripts/make_fragments.pl .')
os.system('time ./make_fragments.pl -verbose -nohoms ' + pdbid + final_chains + '.fasta 2>&1 -template ' + pdbid + ' | tee make_fragments_' + pdbid + '.pl.log')

