#!/usr/bin/perl

use POSIX ":sys_wait_h";
sub usage {
  die <<END;
  USAGE : preprocessing.pl <single pdb file | file with list of pdb files>
  RESULT : Runs preprocessing for domain insertion mode for the pdb or list of pdbs.
  Also requires a file that is tab-separated with fields of chain, protein size, parent domain 1, parent domain 2,
  insertion domain.

END
}

usage unless scalar(@ARGV) == 1;

$infile = $ARGV[0];
$filetype = substr($infile,-3,3);
$kid = -1;

# determine whether the script is to be run on a single pdb file
# or a list of pdb files
if ($filetype eq 'pdb') {
  &preprocess($infile);
} else {
  open(LIST,$infile);
  while($line=<LIST>) {
    chomp $line;
    $dir = `pwd`;
    &preprocess($line);
  }
}

# calls the list of functions to do preprocessing
sub preprocess {
  my ($pdbfile) = @_;
  print "$pdbfile\n";
  $pdbinfo = "\$domain_insertion/pdb_info.txt";
  $pdb = substr($pdbfile,0,4);
  $chain = `awk '/$pdb/ {print \$2}' $pdbinfo | tr -d '\t\n'`;
  $host1 = `awk '/$pdb/ {print \$4}' $pdbinfo | tr -d '\t\n'`;
  $host2 = `awk '/$pdb/ {print \$5}' $pdbinfo | tr -d '\t\n'`;
  $insert = `awk '/$pdb/ {print \$6}' $pdbinfo | tr -d '\t\n'`;
  &setup($pdb);
}

# make all the subdirectories required for preprocessing
# copy necessary files
sub setup {
  my ($pdb) = @_;
  print "pdb: $pdb\n";
  my $out = substr($pdb,1,3);

  $kid = -1;

  print "$chain $host1 $host2 $insert\n";
  `mkdir $pdb`;
  chdir($pdb);
      `mkdir shell`;
      `mkdir setup`;
      `mkdir prepack`;
      chdir("setup");
        print "in setup\n";
        `cp \$domain_insertion/domins.paths paths.txt`;
        print "exiting setup\n";
      chdir("..");
      chdir("prepack");
        `cp \$domain_insertion/prepack.paths paths.txt`;
        `cp \$domain_insertion/ppk.bash .`;
      chdir("..");
  chdir("..");

  $kid = 0;

}
