#!/usr/bin/perl

use POSIX ":sys_wait_h";
sub usage {
  die <<END;
  USAGE : refine.pl <pdb file name>
  RESULT : Runs preprocessing for domain insertion mode for the pdb or list of pdbs.
  Also requires a file that is tab-separated with fields of chain, protein size, parent domain 1, parent domain 2,
  insertion domain.

END
}

usage unless scalar(@ARGV) == 1;

$pdb = $ARGV[0];
# this is the path to rosetta executable, please modify it to match your local paths
$rosetta = "/home/monica/simcode/workspaces/monica/switch/rosetta++/rosetta.gcc";
$kid = -1;

# this is the path to pdb file directory, please modify it to match your local paths
$file_dir = "/home/monica/domain_insertion/working/low_res/$pdb";
$infile = "$file_dir/pdb_list";
print $infile;

open(LIST,$infile);
while($line=<LIST>) {
  chomp $line;
  chdir("/home/monica/domain_insertion/domins_pdbs");
  $dir = `pwd`;
  &refine($line);
}

# calls the list of functions to do preprocessing
sub refine {
  my ($decoyfile) = @_;
  print "$decoyfile\n";
  $decoy = substr($decoyfile,6,4);
  &setup($pdb, $decoy, $decoyfile);
  waitpid($kid, 0);
  &run($pdb, $decoy);
}

# make all the subdirectories required for preprocessing
# copy necessary files
sub setup {
  my ($pdb,$decoy,$decoyfile) = @_;
  print "pdb: $pdb\n";
  $kid = -1;

  chdir($pdb);
    `mkdir refine_decoys`;
    chdir("refine_decoys");
        `mkdir $decoy`;
        chdir($decoy);
            `cp ../../shell/* .`;
            `cp ../../shell/$pdb.pdb ./$pdb.native.pdb`;
            `cp $file_dir/$decoyfile ./$pdb.pdb`;
            symlink($rosetta, "rosetta.gcc");
        chdir("..");
    chdir("..");
  chdir("..");

  $kid = 0;

}

# run refinement
sub run {
  my ($pdb,$decoy) = @_;
  $kid = -1;
  print "**************Running $decoy******************\n";
  chdir("$pdb/refine_decoys/$decoy/");
     `./rosetta.gcc RF $pdb A -domain_insertion -fast_relax_only -fa_output -timer -insertion_file insertion_file.prm -nstruct 10 -l &> refine.out`;
  chdir("../../../");
  print "**************Run Complete******************\n";
  $kid = 0;
}
