#!/usr/bin/perl

$infile = $ARGV[0];
$dirtype = $ARGV[1];
$filetype = substr($infile,-3,3);
# this is the path to rosetta executable, please modify it to match your local paths
$rosetta = "/home/monica/simcode/workspaces/monica/switch/rosetta++/rosetta.gcc";

if ($filetype eq 'pdb') {
  &preprocess($infile);
} else {
  open(LIST,$infile);
  while($line=<LIST>) {
    chomp $line;
    chdir("/home/monica/domain_insertion/domins_pdbs");
    $dir = `pwd`;
    print "pwd: $dir\n";
    &preprocess($line);
  }
}

# calls the list of functions to do preprocessing
sub preprocess {
  my ($pdbfile) = @_;
  print "$pdbfile\n";
  $pdbinfo = "pdb_info.txt";
  $pdb = substr($pdbfile,0,4);
  $chain = `awk '/$pdb/ {print \$2}' $pdbinfo | tr -d '\t\n'`;
  if ($chain eq '_') {
    $chain = 'A';
  }
  $host1 = `awk '/$pdb/ {print \$4}' $pdbinfo | tr -d '\t\n'`;
  $host2 = `awk '/$pdb/ {print \$5}' $pdbinfo | tr -d '\t\n'`;
  $insert = `awk '/$pdb/ {print \$6}' $pdbinfo | tr -d '\t\n'`;
  &create_shell($pdb);
}
sub create_shell {
  my ($pdb) = @_;
  my $out = substr($pdb,1,3);
  my $count = 0;
  $kid = -1;
  print "**************SHELL******************\n";
  chdir($pdb);
    $dir = `pwd`;
    print "pwd: $dir\n";
      #chdir("prepack/$dirtype/");
      chdir("prepack/$pdb.ppk/aa/");
        open(INFILE, "$pdb.ppk.pdb");
        open(HOSTOUT, ">${out}1.ppk.pdb");
        open(INSERTOUT, ">${out}2.ppk.pdb");
        while ($line=<INFILE>) {
          chomp($line);
          if (substr($line,0,4) eq "ATOM") {
            if ($count == 0) {
                print HOSTOUT "$line\n";
            } else {
              print INSERTOUT "$line\n";
            }
          } elsif (substr($line,0,3) eq "TER") {
            $count++;
          }
        }
        $dir =~ s/^\s+//;
        $dir =~ s/\s+$//;
      chdir("$dir");
      `mkdir shell`;
      chdir("shell");
        `cp ../insertion_file.prm .`;
        `cp ../prepack/$pdb.ppk/aa/*ppk* .`;
        #`cp ../prepack/$dirtype/*ppk* .`;
        `cp ../setup/aa${pdb}${chain}03_05.200_v1_3 aa${pdb}${chain}03_05.200_new_c`;
        `cp ../setup/aa${pdb}${chain}09_05.200_v1_3 aa${pdb}${chain}09_05.200_new_c`;
        `cp ../setup/$pdb*.fasta .`;
        `cp ../setup/$pdb.pdb .`;
        `cp ../setup/$out*.pdb .`;
        `cp ../setup/paths.txt .`;
      chdir("..");
  chdir("..");
  print "**************SHELL DONE******************\n";
  $kid = 0;
}
