;; Emacs setup for Rosetta developers
;; JJG 8/16/2004

;; this script provides some miscellaneous shortcuts for easier development
;; of Rosetta with emacs, including
;;
;;  -Function key shortcuts
;;     F1    -> Jump to subroutine/function
;;     F2    -> Back to previous subroutine/function
;;     F3    -> Jump to subroutine in a new window
;;     F4    -> Complete subroutine/function name
;;     F5/F6 -> Comment/uncomment region
;;     F7    -> Search and replace in this file
;;     F8    -> Goto line
;;     Alt-F7/F8  -> Cut & Paste rectangle (columns)
;;     F9    -> Compile on a remote machine
;;     F10   -> Compile on local machine
;;     F11   -> Jump to next (previous) error (with Alt-F11)
;;     F12   -> Undo (can be used multiple times, press a cursor key
;;                    and F12 will now be 'redo', press a cursor key
;;                    again to toggle back to 'undo')
;;
;;  -automatic trailing whitespace removal
;;  -Parentheses matching
;;  -Activate fortran mode in rosetta-f77 directories
;;
;; **Feel free to add stuff in here to share!**



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; to use this script:
;;
;; 1. copy this file to ~/.Emacs_dir/
;;
;; 2. add these lines to the file ~/.emacs:

;;   ; Add my personal emacs directory to the load path
;;   ; and load my setup files first
;;   (setq load-path (append (list (expand-file-name "~/.Emacs_dir"))
;; 			load-path ))
;;   (require 'rosetta) ; will load from ~/.Emacs_dir
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; OR, just copy all the following lines into your own .emacs
;;     (except the last line)





; key bindings ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; tags -- for quick jumping to functions
(global-set-key [f1] 'find-tag)
(global-set-key [f2] 'pop-tag-mark)
(global-set-key [f3] 'find-tag-other-window)
(global-set-key [f4] 'complete-tag)

;comment and uncomment region
(global-set-key [f5] 'comment-region)
(global-set-key [f6] 'uncomment-region)

;rectangle cut and paste
(global-set-key [M-f7] 'kill-rectangle)
(global-set-key [M-f8] 'yank-rectangle)

;misc
(global-set-key [f7]    'query-replace)
(global-set-key [f8]    'goto-line)

;compile
(global-set-key [f9]    'remote-compile)  ; see compile note below
(global-set-key [f10]   'compile)
(global-set-key [f11]   'next-error)
(global-set-key [M-f11] 'previous-error)

;undo
(global-set-key [f12]   'undo)


;remote compile -- for compiling rosetta on hell/pole/any_other_box
(setq remote-shell-program "ssh")
(setq remote-compile-run-before "source .bashrc")


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; parenthesis matching
(load "paren")
(show-paren-mode t)



;remove trailing spaces (required for rosetta++ development)
(require `rm-tspaces)
(add-hook `c++-mode-hook `rm-trailing-spaces-always)



; shorthand for commenting and uncommenting regions with ^C; and ^C:
;(define-key global-map "\C-c;" 'comment-region)
;(define-key global-map "\C-c:" "\M--1\C-c;")
;; doesn't work in emacs 21.3 cc-mode, don't know why
;; probably a conflict with a C++ shortcut needs to be resolved



; put emacs into the proper mode for certain files
; not helpful for Rosetta source, but for related files and development
(setq auto-mode-alist
  (append '(
	    ("\\.bash\\'" . sh-mode)
	    ("rosetta-f77/.*\\.h\\'"
	          . fortran-mode) ;Rosetta fortran header files
	    ("\\.aliases" . sh-mode)
	    ("\\.bashrc" . sh-mode)
	    ("rosettarc" . sh-mode)
	    ("README" . text-mode)
	    ("[Ll][Oo][Gg]" . text-mode) ; log files
            ("\\.dat$"  . text-mode)
           ) auto-mode-alist))



; C++ ident stuff --chu
(setq c-offsets-alist
      '((arglist-cont-nonempty . +) ;; enable indentation for continuing argment
	(arglist-close . 0)  ;; Disable indentation for the argument closing parenthesis
	(innamespace . 0) )) ;; Disable identation when in namespace blocks



;; wishlist:
;; -someone familiar with the setting for all the automatic whitespace
;;  should fix them all.  The rosetta header lines already force tabs instead
;;  of spaces, and removes trailing whitespace.  However, continuation lines
;;  and aligned-comments do not always come out properly.

;; -easy ways to jump from source to header file, perhaps even updating the
;;  definition in the other file (I've seen this on the web in other scripts
;;  but have not gotten them to work)

(provide 'rosetta)
