#!/usr/bin/env perl

# put Rosetta radii in the B-factor field of a PDB file
# to display these, use "spacefill temperature" in Rasmol
#
# 2004, John Karanicolas, Baker group, UW

sub usage {
  printf STDERR "usage:   rosettaRadii.pl [PDBfile]\n";
  exit 1;
}

use vars qw ( $perllibdir );

BEGIN {
  $perllibdir="$ENV{MMTSBDIR}/perl" if (defined $ENV{MMTSBDIR});
  ($perllibdir=$0)=~s/[^\/]+$// if (!defined $perllibdir);
}

use lib $perllibdir;
use strict;
use RosettaMolecule;

my $fname="-";

while ($#ARGV>=0) {
  if ($ARGV[0] eq "-help" || $ARGV[0] eq "-h") {
    &usage();
  } else {
    $fname = shift @ARGV;
  }
}

my $Rmol=RosettaMolecule->new($fname);
$Rmol->setBfactorsRadii();
$Rmol->writePDB("-");
exit(0);
