#include <stdlib.h>
#include <stdio.h>
#include "g_config.h"
#include <string.h>
/* Gong's configuration Parsing Library */
/* Written by Gong Cheng */
/* All rights reserved,2003 */
int g_config_parse_command_line(g_config_settings *gcs,int argc,char **argv)
{
	int tt_argm;
	int tt_optn;
	int i,j;
	int total_number;
	int total_dot;
	char option_readin[255];
	int option_index=0;
	char option_char_index;
	tt_argm=0;
	tt_optn=0;
	if (argc < MAX_ARGUMENT_NUMBER) {
	for (i=0;i<MAX_ARGUMENT_NUMBER;i++)
	{
		(*gcs).option_type[i]=-1;
	}
	for (i=1;i<argc;i++)
	{
		if (argv[i][0]=='-')
		{
			// put this guy into option	
			if (strlen(argv[i])<255)
			{
				strcpy(option_readin,argv[i]+2);
				option_char_index=argv[i][1];
				if ((option_char_index>='a') && (option_char_index<='z'))
				{
					option_index=option_char_index-'a';
				}else if ((option_char_index>='A')&&(option_char_index<='Z'))
				{
					option_index=option_char_index-'A'+26;
				}else if ((option_char_index>='0')&&(option_char_index<='9'))
				{
					option_index=option_char_index-'0'+52;
				}else 
				{
					fprintf(stderr,"Unexpeced option %c in %d position\n",option_char_index,i);
					exit(0);
				}
				//right now, we should try to categorize them
				total_number=0;
				total_dot=0;
				for (j=0;j<strlen(option_readin);j++)
				{
					if ((option_readin[j]<='9') && (option_readin[j]>='0'))
					{
						total_number++;
					}else if (option_readin[j]=='.'){
						total_dot++;				
					}
				}
				if (strlen(option_readin)==0)
				{
					(*gcs).option_type[option_index]=0;
				}	
				else if (total_number==strlen(option_readin))
				{
					sscanf(option_readin,"%d",&(*gcs).option_int_value[option_index]);
					(*gcs).option_type[option_index]=1;	
					//this means we got an integer
				}else if ((total_number==strlen(option_readin)-1)&&total_dot==1)
				{
					sscanf(option_readin,"%f",&(*gcs).option_float_value[option_index]);
					(*gcs).option_type[option_index]=2;
					//this means we got an float
				}else {
					(*gcs).option_type[option_index]=3;	
				        strcpy((*gcs).option_string_value[option_index],option_readin);	//this means we got an string
				}
			}	
		}else{
			// put this guy into argument
			if (strlen(argv[i])<255){
				strcpy((*gcs).argument[tt_argm],argv[i]);
				tt_argm++;
		  	}
		}//end of else
	}//end of for 
        }//end of if argc <MAX_ARGUMENT_NUMBER
	else 
	{
		printf("Too many arguments in command line, all arguments are omitted\n");
	}
	(*gcs).total_argument_number=tt_argm;
//fprintf(stderr,"%d\n",tt_argm);
	return 0;
}

int g_config_get_option_type(g_config_settings *gcs,char option_char_index)
//Cool, this program is the hard working 
{
	int option_index;
	if ((option_char_index>='a') && (option_char_index<='z'))
	{
		option_index=option_char_index-'a';
	}else if ((option_char_index>='A')&&(option_char_index<='Z'))
	{
		option_index=option_char_index-'A'+26;
	}else if ((option_char_index>='0')&&(option_char_index<='9'))
	{
		option_index=option_char_index-'0'+52;
	}else 
	{
		fprintf(stderr,"Unexpeced option %c in query\n",option_char_index);
		exit(0);
	}
	return (*gcs).option_type[option_index];
}

int g_config_get_total_argument_number(g_config_settings *gcs)
{
	return (*gcs).total_argument_number;
}

char* g_config_get_argument(g_config_settings *gcs,int argument_index)
{
	char* arg;
	if ((argument_index<1)||(argument_index>(*gcs).total_argument_number))
	{
		arg=NULL;
	}else
	{
		argument_index--;
		arg=(*gcs).argument[argument_index];
	}
	return arg;
}

int g_config_get_int_option(g_config_settings *gcs,int option_char_index,int *int_value)
{
	int error_code;
	int option_index;
	// first of all, check whether this one is a int option
	if ((option_char_index>='a') && (option_char_index<='z'))
	{
		option_index=option_char_index-'a';
	}else if ((option_char_index>='A')&&(option_char_index<='Z'))
	{
		option_index=option_char_index-'A'+26;
	}else if ((option_char_index>='0')&&(option_char_index<='9'))
	{
		option_index=option_char_index-'0'+52;
	}else 
	{
		fprintf(stderr,"Unexpeced option %c in query\n",option_char_index);
		exit(EXIT_FAILURE);
	}

	if (g_config_get_option_type(gcs,option_char_index)!=1)
	{
		error_code=-1;
	}else{
		error_code=0;
		(*int_value)=(*gcs).option_int_value[option_index];
	}
	return error_code;
}

int g_config_get_double_option(g_config_settings *gcs,int option_char_index,double *double_value)
{
	int error_code;
	int option_index;
	// first of all, check whether this one is a int option
	if ((option_char_index>='a') && (option_char_index<='z'))
	{
		option_index=option_char_index-'a';
	}else if ((option_char_index>='A')&&(option_char_index<='Z'))
	{
		option_index=option_char_index-'A'+26;
	}else if ((option_char_index>='0')&&(option_char_index<='9'))
	{
		option_index=option_char_index-'0'+52;
	}else 
	{
		fprintf(stderr,"Unexpeced option %c in query\n",option_char_index);
		exit(EXIT_FAILURE);
	}

	if (g_config_get_option_type(gcs,option_char_index)!=2)
	{
		error_code=-1;
	}else{
		error_code=0;
		(*double_value)=(*gcs).option_float_value[option_index];
	}
	return error_code;
}

int g_config_get_float_option(g_config_settings *gcs,int option_char_index,float *float_value)
{
	int error_code;
	int option_index;
	// first of all, check whether this one is a int option
	if ((option_char_index>='a') && (option_char_index<='z'))
	{
		option_index=option_char_index-'a';
	}else if ((option_char_index>='A')&&(option_char_index<='Z'))
	{
		option_index=option_char_index-'A'+26;
	}else if ((option_char_index>='0')&&(option_char_index<='9'))
	{
		option_index=option_char_index-'0'+52;
	}else 
	{
		fprintf(stderr,"Unexpeced option %c in query\n",option_char_index);
		exit(EXIT_FAILURE);
	}

	if (g_config_get_option_type(gcs,option_char_index)!=2)
	{
		error_code=-1;
	}else{
		error_code=0;
		(*float_value)=(*gcs).option_float_value[option_index];
	}
	return error_code;
}

int g_config_get_string_option(g_config_settings *gcs,int option_char_index,char *string_value)
{
	int error_code;
	int option_index;
	// first of all, check whether this one is a int option
	if ((option_char_index>='a') && (option_char_index<='z'))
	{
		option_index=option_char_index-'a';
	}else if ((option_char_index>='A')&&(option_char_index<='Z'))
	{
		option_index=option_char_index-'A'+26;
	}else if ((option_char_index>='0')&&(option_char_index<='9'))
	{
		option_index=option_char_index-'0'+52;
	}else 
	{
		fprintf(stderr,"Unexpeced option %c in query\n",option_char_index);
		exit(EXIT_FAILURE);
	}

	if (g_config_get_option_type(gcs,option_char_index)!=3)
	{
		error_code=-1;
	}else{
		error_code=0;
		strcpy(string_value,(*gcs).option_string_value[option_index]);
	}
	return error_code;
}
