#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <assert.h>
#include <time.h>
#include "g_config.h"
#define MAX_FILE 500
int total_residue[MAX_FILE];
double Eatr[MAX_FILE][1000][20];
double Erep[MAX_FILE][1000][20];
double Esol[MAX_FILE][1000][20];
double Eaa[MAX_FILE][1000][20];
double Edun[MAX_FILE][1000][20];
double Eintra[MAX_FILE][1000][20];
double Ehbond[MAX_FILE][1000][20];
double Epair[MAX_FILE][1000][20];
double Prob[MAX_FILE][1000][20];
int tot_file;
double calculate_probability_RMSD(int record_no,double Watr,double Wrep, double Wsol,double Waa, double Wdun,double Wintra,double Whbond,double Wpair);
int usage(char *programname);

int main(int argc,char** argv)
{
	g_config_settings gcs;
	FILE *score_list_file;
	char score_filename[255];
	double Watr,Wrep,Wsol,Waa,Wdun,Wintra,Whbond,Wpair;
	double lWatr,lWrep,lWsol,lWaa,lWdun,lWintra,lWhbond,lWpair;
	int i,j,k;
	double rmsd;
	double lrmsd;
        srand((unsigned int)time( NULL ));
	g_config_parse_command_line(&gcs,argc,argv);
//	fprintf(stderr,"%d\n",g_config_get_total_argument_number(&gcs));
	if (g_config_get_total_argument_number(&gcs)<1)
	{
	 //   fprintf(stderr,"%d\n",g_config_get_total_argument_number(&gcs));
            usage(argv[0]);
            exit(EXIT_SUCCESS);
	}							              
	//fprintf(stderr,"%d\n",g_config_get_total_argument_number(&gcs));
	score_list_file=fopen(g_config_get_argument(&gcs,1),"r");
	assert(score_list_file!=NULL);
	tot_file=0;
	Watr=1.0*rand()/RAND_MAX;Wrep=1.0*rand()/RAND_MAX;Wsol=1.0*rand()/RAND_MAX;Waa=1.0*rand()/RAND_MAX;Wdun=1.0*rand()/RAND_MAX;Wintra=1.0*rand()/RAND_MAX;Whbond=1.0*rand()/RAND_MAX;Wpair=1.0*rand()/RAND_MAX;
	while(fgets(score_filename,250,score_list_file)!=NULL){		
		for (i=0;i<strlen(score_filename);i++){
			if (score_filename[i]=='\n'){
				score_filename[i]='\0';
			}
		}
		total_residue[tot_file]=read_score_file(score_filename);
		tot_file++;
		assert(tot_file<MAX_FILE);
	}
	fclose(score_list_file);
	lrmsd=1000;
	for (k=1;k<100;k++)
	for (j=0;j<1000;j++){
        rmsd=0;	
	for (i=0;i<tot_file;i++){
//	printf("%f\n",rmsd);
	  rmsd=rmsd+calculate_probability_RMSD(i,Watr,Wrep,Wsol,Waa,Wdun,Wintra,Whbond,Wpair);
//	printf("%f\n",rmsd);
	}
	rmsd=rmsd/tot_file;
	printf("%f : %f %f %f %f %f %f %f %f\n",rmsd,Watr,Wrep,Wsol,Waa,Wdun,Wintra,Whbond,Wpair);
	if (rmsd<lrmsd){
		lrmsd=rmsd;		
		lWatr=Watr;lWrep=Wrep;lWsol=Wsol;lWaa=Waa;lWdun=Wdun;lWintra=Wintra;lWhbond=Whbond;lWpair=Wpair;
	}else{
		Watr=lWatr;Wrep=lWrep;Wsol=lWsol;Waa=lWaa;Wdun=lWdun;Wintra=lWintra;Whbond=lWhbond;Wpair=lWpair;	
	}
		Watr=Watr+((float)(rand())/RAND_MAX)/k;
		Wrep=Wrep+((float)(rand())/RAND_MAX)/k;
		Wsol=Wsol+((float)(rand())/RAND_MAX)/k;
		Waa=Waa+((float)(rand())/RAND_MAX)/k;
		Wdun=Wdun+((float)(rand())/RAND_MAX)/k;
		Wintra=Wintra+((float)(rand())/RAND_MAX)/k;
		Whbond=Whbond+((float)(rand())/RAND_MAX)/k;
		Wpair=Wpair+((float)(rand())/RAND_MAX)/k;
	}
	// 1 read in the parameters
	// 2 calculate the value we want to know 	
	// 3 output it
	exit(EXIT_SUCCESS);
}

double calculate_probability_RMSD(int record_no,double Watr,double Wrep, double Wsol,double Waa, double Wdun,double Wintra,double Whbond,double Wpair)
{
	double rmsd;
	double mother,son;
	double prob;
	double E;
	double eatr,erep,esol,eaa,edun,eintra,ehbond,epair;
	double p2,p1;
	double delta;
	int i,j;
	rmsd=0;
	for (i=1;i<=total_residue[record_no];i++){
		mother=0;
		for (j=0;j<20;j++){
			eatr=Eatr[record_no][i][j];
			erep=Erep[record_no][i][j];
			esol=Esol[record_no][i][j];
			eaa=Eaa[record_no][i][j];
			edun=Edun[record_no][i][j];	
			eintra=Eintra[record_no][i][j];
			ehbond=Ehbond[record_no][i][j];
			epair=Epair[record_no][i][j];
			E=Watr*eatr+Wrep*erep+Wsol*esol+Waa*eaa+Wdun*edun+Wintra*eintra+Whbond*ehbond+Wpair*epair;	
//			printf("E=%d  %f \n",j,E);
	//		printf("%d %d %d : %f %f %f %f %f %f %f %f\n",record_no,i,j,eatr,erep,esol,eaa,edun,eintra,ehbond,epair);
			if (E<-500){
				E=-500;
			}
			mother=mother+exp(-E);
		}
//		printf("mother %f\n",mother);
		for (j=0;j<20;j++){
			eatr=Eatr[record_no][i][j];
			erep=Erep[record_no][i][j];
			esol=Esol[record_no][i][j];
			eaa=Eaa[record_no][i][j];
			edun=Edun[record_no][i][j];	
			eintra=Eintra[record_no][i][j];
			ehbond=Ehbond[record_no][i][j];
			epair=Epair[record_no][i][j];
			E=Watr*eatr+Wrep*erep+Wsol*esol+Waa*eaa+Wdun*edun+Wintra*eintra+Whbond*ehbond+Wpair*epair;	
			if (E<-500){
				E=-500;
			}
			son=exp(-E);
			prob=son/mother;
//			printf("%d %d %d : %f %f\n",record_no,i,j,prob,Prob[record_no][i][j]);	
			if (prob!=0)
			{
				p1=log(prob);
			}else{
				p1=0;
			}
			if (Prob[record_no][i][j]!=0){
				p2=log(Prob[record_no][i][j]);
			}else{
				p2=0;
			}
			delta=p1-p2;
			rmsd=rmsd+delta*delta;
		}
	}
//	printf("C1 %f\n",rmsd);
	rmsd=sqrt(rmsd);
//	printf("%f\n",rmsd);
	assert(total_residue[record_no]!=0);
	rmsd=rmsd/total_residue[record_no];
//	printf("C2 %f\n",rmsd);
	return rmsd;
}

int read_score_file(char* score_filename)
{
	FILE *SCORE_FILE;
	char scoreline[255];
	int res_num,pdb_res_num,mutantcode;
	float prob,eatr,erep,esol,eaa,edun,eintra,ehbond,epair;
	char mutant;
	SCORE_FILE=fopen(score_filename,"r");
//	printf("%s\n",score_filename);
	assert(SCORE_FILE!=NULL);
//	printf("huhu%s\n",score_filename);
	res_num=0;
	while(fgets(scoreline,250,SCORE_FILE)){
		//printf("%s",scoreline);
		sscanf(scoreline,"%d %d %c %d %f %f %f %f %f %f %f %f %f %f",&res_num,&pdb_res_num,&mutant,&mutantcode,&prob,&eatr,&erep,&esol,&eaa,&edun,&eintra,&ehbond,&epair);
		Prob[tot_file][res_num][mutantcode]=prob;
		Eatr[tot_file][res_num][mutantcode]=eatr;		
		Erep[tot_file][res_num][mutantcode]=erep;
		Esol[tot_file][res_num][mutantcode]=esol;
		Eaa[tot_file][res_num][mutantcode]=eaa;
		Edun[tot_file][res_num][mutantcode]=edun;
		Eintra[tot_file][res_num][mutantcode]=eintra;
		Ehbond[tot_file][res_num][mutantcode]=ehbond;
		Epair[tot_file][res_num][mutantcode]=epair;
		//printf("%d %d %d : %f %f %f %f %f %f %f %f\n",tot_file,res_num,mutantcode,eatr,erep,esol,eaa,edun,eintra,ehbond,epair);
	}
	fclose(SCORE_FILE);
	return res_num;
}

int usage(char *programname)
{
	printf("Give me a list of score files and weights, I will be able to output the RMSD between the predicted probability and natural probability\n");
	printf("Usage: %s <score list file name> -a<Eatr Weight> -r<Erep Weight> -s<Esol Weight> -o<Eaa Weight> -d<Edun Weight> -i<Eintra Weight> -h<Ehbond weight> -p<Epair weight>\n", programname);
	exit(EXIT_SUCCESS);
}
