#!/usr/bin/awk -f
substr(FILENAME,11,4)==".pdb" {
  base = substr(FILENAME,1,5);
  if (base != old_base) {
    complete = 0;
    old_base = base;
    count[base]=0;
    torsion_count[base]=0;;
  }
  start_profile = 0;
}  

start_profile {
  check_count[check_base]++;
  for (i=2;i<=21;i++) {
    profile[check_base,check_count[check_base],i-1] = $i;
  }
}
FILENAME ~ "checkPROFILE" {
  check_base = substr(FILENAME,1,5);
  complete = 0;
  if (check_base != old_check_base) {
    reported_count[check_base] = $1;
#    print reported_count[check_base];
    check_count[check_base] = 0;
    old_check_base = check_base;
    start_profile = 1;
  }
}  

$3=="CA" {
  ca_count[base]++;
  i =   ca_count[base];
  ca[base,i,1] = $7;
  ca[base,i,2] = $8;
  ca[base,i,3] = $9;
  real_res[base,i] = $4;
}
complete {
  torsion_count[base]++;
  i = torsion_count[base];
  res[base,i] = $8;
  ss[base,i] = $2;
  tor[base,i,1] = $3;
  tor[base,i,2] = $4;
  tor[base,i,3] = $5;
}

$1=="complete:" {
  complete = 1;

}
END {
  for (base in ca_count) {
    if (reported_count[base]) {
      if (reported_count[base]==torsion_count[base]) {
	for (i = 1;i<=reported_count[base];i++) {
	  printf ("%5s %1s %1s %5d %4d %4d %8.2f %8.2f %8.2f %8.3f %8.3f %8.3f %8.3f %3d %4.2f %5.3f",
		  base,
		  res[base,i],
		  ss[base,i],
		  i,
		  reported_count[base] - (i),
		  i-1,
		  ca[base,i,1],
		  ca[base,i,2],
		  ca[base,i,3],
		  tor[base,i,1],
		  tor[base,i,2],
		  tor[base,i,3],
		  0.0,
		  10,
		  0.0,
		  0.0		);
# profiles
	  for (j=1; j <= 20; j++) {
	    printf (" %5.3f", profile[base,i,j]);
	  }
	  printf "\n";                                          # for now
	}
      }
      else {
	print "warning, mismatch between residue count in "base".checkPROFILE and "base".pdb ?\n"
	  base" will not be in this vall"  > "/dev/stderr";
      }
    } 
    else {
      print "warning, no .checkPROFILE for "base" ?\n" base" will not be in this vall"  > "/dev/stderr";;
    }
  }
}
