// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#ifndef INCLUDED_ObjexxFCL_CPArray_FWD_HH
#define INCLUDED_ObjexxFCL_CPArray_FWD_HH


// CPArray Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class CPArray;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  CPArray< bool >                CPArray_bool;
typedef  CPArray< sbyte >                CPArray_byte;
typedef  CPArray< ubyte >               CPArray_ubyte;
typedef  CPArray< short int >           CPArray_short;
typedef  CPArray< int >                 CPArray_int;
typedef  CPArray< long int >            CPArray_long;
typedef  CPArray< unsigned short int >  CPArray_ushort;
typedef  CPArray< unsigned int >        CPArray_uint;
typedef  CPArray< unsigned long int >   CPArray_ulong;
typedef  CPArray< std::size_t >         CPArray_size_t;
typedef  CPArray< std::size_t >         CPArray_size;
typedef  CPArray< float >               CPArray_float;
typedef  CPArray< double >              CPArray_double;
typedef  CPArray< long double >         CPArray_longdouble;
typedef  CPArray< char >                CPArray_char;
typedef  CPArray< unsigned char >       CPArray_uchar;
typedef  CPArray< signed char >         CPArray_schar;
typedef  CPArray< std::string >         CPArray_string;
typedef  CPArray< Fstring >             CPArray_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_CPArray_FWD_HH
