// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#ifndef INCLUDED_ObjexxFCL_ChunkVector_FWD_HH
#define INCLUDED_ObjexxFCL_ChunkVector_FWD_HH


// ChunkVector Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class ChunkVector;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  ChunkVector< bool >                ChunkVector_bool;
typedef  ChunkVector< sbyte >                ChunkVector_byte;
typedef  ChunkVector< ubyte >               ChunkVector_ubyte;
typedef  ChunkVector< short int >           ChunkVector_short;
typedef  ChunkVector< int >                 ChunkVector_int;
typedef  ChunkVector< long int >            ChunkVector_long;
typedef  ChunkVector< unsigned short int >  ChunkVector_ushort;
typedef  ChunkVector< unsigned int >        ChunkVector_uint;
typedef  ChunkVector< unsigned long int >   ChunkVector_ulong;
typedef  ChunkVector< std::size_t >         ChunkVector_size_t;
typedef  ChunkVector< std::size_t >         ChunkVector_size;
typedef  ChunkVector< float >               ChunkVector_float;
typedef  ChunkVector< double >              ChunkVector_double;
typedef  ChunkVector< long double >         ChunkVector_longdouble;
typedef  ChunkVector< char >                ChunkVector_char;
typedef  ChunkVector< unsigned char >       ChunkVector_uchar;
typedef  ChunkVector< signed char >         ChunkVector_schar;
typedef  ChunkVector< std::string >         ChunkVector_string;
typedef  ChunkVector< Fstring >             ChunkVector_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_ChunkVector_FWD_HH
