// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#ifndef INCLUDED_ObjexxFCL_FArray1DB_FWD_HH
#define INCLUDED_ObjexxFCL_FArray1DB_FWD_HH


// FArray1DB Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray1DB;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  FArray1DB< bool >                FArray1DB_bool;
typedef  FArray1DB< sbyte >                FArray1DB_byte;
typedef  FArray1DB< ubyte >               FArray1DB_ubyte;
typedef  FArray1DB< short int >           FArray1DB_short;
typedef  FArray1DB< int >                 FArray1DB_int;
typedef  FArray1DB< long int >            FArray1DB_long;
typedef  FArray1DB< unsigned short int >  FArray1DB_ushort;
typedef  FArray1DB< unsigned int >        FArray1DB_uint;
typedef  FArray1DB< unsigned long int >   FArray1DB_ulong;
typedef  FArray1DB< std::size_t >         FArray1DB_size_t;
typedef  FArray1DB< std::size_t >         FArray1DB_size;
typedef  FArray1DB< float >               FArray1DB_float;
typedef  FArray1DB< double >              FArray1DB_double;
typedef  FArray1DB< long double >         FArray1DB_longdouble;
typedef  FArray1DB< char >                FArray1DB_char;
typedef  FArray1DB< unsigned char >       FArray1DB_uchar;
typedef  FArray1DB< signed char >         FArray1DB_schar;
typedef  FArray1DB< std::string >         FArray1DB_string;
typedef  FArray1DB< Fstring >             FArray1DB_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray1DB_FWD_HH
