// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#ifndef INCLUDED_ObjexxFCL_FArray1Dp_FWD_HH
#define INCLUDED_ObjexxFCL_FArray1Dp_FWD_HH


// FArray1Dp Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray1Dp;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  FArray1Dp< bool >                FArray1Dp_bool;
typedef  FArray1Dp< sbyte >                FArray1Dp_byte;
typedef  FArray1Dp< ubyte >               FArray1Dp_ubyte;
typedef  FArray1Dp< short int >           FArray1Dp_short;
typedef  FArray1Dp< int >                 FArray1Dp_int;
typedef  FArray1Dp< long int >            FArray1Dp_long;
typedef  FArray1Dp< unsigned short int >  FArray1Dp_ushort;
typedef  FArray1Dp< unsigned int >        FArray1Dp_uint;
typedef  FArray1Dp< unsigned long int >   FArray1Dp_ulong;
typedef  FArray1Dp< std::size_t >         FArray1Dp_size_t;
typedef  FArray1Dp< std::size_t >         FArray1Dp_size;
typedef  FArray1Dp< float >               FArray1Dp_float;
typedef  FArray1Dp< double >              FArray1Dp_double;
typedef  FArray1Dp< long double >         FArray1Dp_longdouble;
typedef  FArray1Dp< char >                FArray1Dp_char;
typedef  FArray1Dp< unsigned char >       FArray1Dp_uchar;
typedef  FArray1Dp< signed char >         FArray1Dp_schar;
typedef  FArray1Dp< std::string >         FArray1Dp_string;
typedef  FArray1Dp< Fstring >             FArray1Dp_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray1Dp_FWD_HH
