// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#ifndef INCLUDED_ObjexxFCL_FArray2DB_FWD_HH
#define INCLUDED_ObjexxFCL_FArray2DB_FWD_HH


// FArray2DB Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray2DB;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  FArray2DB< bool >                FArray2DB_bool;
typedef  FArray2DB< sbyte >                FArray2DB_byte;
typedef  FArray2DB< ubyte >               FArray2DB_ubyte;
typedef  FArray2DB< short int >           FArray2DB_short;
typedef  FArray2DB< int >                 FArray2DB_int;
typedef  FArray2DB< long int >            FArray2DB_long;
typedef  FArray2DB< unsigned short int >  FArray2DB_ushort;
typedef  FArray2DB< unsigned int >        FArray2DB_uint;
typedef  FArray2DB< unsigned long int >   FArray2DB_ulong;
typedef  FArray2DB< std::size_t >         FArray2DB_size_t;
typedef  FArray2DB< std::size_t >         FArray2DB_size;
typedef  FArray2DB< float >               FArray2DB_float;
typedef  FArray2DB< double >              FArray2DB_double;
typedef  FArray2DB< long double >         FArray2DB_longdouble;
typedef  FArray2DB< char >                FArray2DB_char;
typedef  FArray2DB< unsigned char >       FArray2DB_uchar;
typedef  FArray2DB< signed char >         FArray2DB_schar;
typedef  FArray2DB< std::string >         FArray2DB_string;
typedef  FArray2DB< Fstring >             FArray2DB_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray2DB_FWD_HH
