// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#ifndef INCLUDED_ObjexxFCL_FArray2Dp_FWD_HH
#define INCLUDED_ObjexxFCL_FArray2Dp_FWD_HH


// FArray2Dp Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray2Dp;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  FArray2Dp< bool >                FArray2Dp_bool;
typedef  FArray2Dp< sbyte >                FArray2Dp_byte;
typedef  FArray2Dp< ubyte >               FArray2Dp_ubyte;
typedef  FArray2Dp< short int >           FArray2Dp_short;
typedef  FArray2Dp< int >                 FArray2Dp_int;
typedef  FArray2Dp< long int >            FArray2Dp_long;
typedef  FArray2Dp< unsigned short int >  FArray2Dp_ushort;
typedef  FArray2Dp< unsigned int >        FArray2Dp_uint;
typedef  FArray2Dp< unsigned long int >   FArray2Dp_ulong;
typedef  FArray2Dp< std::size_t >         FArray2Dp_size_t;
typedef  FArray2Dp< std::size_t >         FArray2Dp_size;
typedef  FArray2Dp< float >               FArray2Dp_float;
typedef  FArray2Dp< double >              FArray2Dp_double;
typedef  FArray2Dp< long double >         FArray2Dp_longdouble;
typedef  FArray2Dp< char >                FArray2Dp_char;
typedef  FArray2Dp< unsigned char >       FArray2Dp_uchar;
typedef  FArray2Dp< signed char >         FArray2Dp_schar;
typedef  FArray2Dp< std::string >         FArray2Dp_string;
typedef  FArray2Dp< Fstring >             FArray2Dp_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray2Dp_FWD_HH
