// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#ifndef INCLUDED_ObjexxFCL_FArray3Da_FWD_HH
#define INCLUDED_ObjexxFCL_FArray3Da_FWD_HH


// FArray3Da Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray3Da;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  FArray3Da< bool >                FArray3Da_bool;
typedef  FArray3Da< sbyte >                FArray3Da_byte;
typedef  FArray3Da< ubyte >               FArray3Da_ubyte;
typedef  FArray3Da< short int >           FArray3Da_short;
typedef  FArray3Da< int >                 FArray3Da_int;
typedef  FArray3Da< long int >            FArray3Da_long;
typedef  FArray3Da< unsigned short int >  FArray3Da_ushort;
typedef  FArray3Da< unsigned int >        FArray3Da_uint;
typedef  FArray3Da< unsigned long int >   FArray3Da_ulong;
typedef  FArray3Da< std::size_t >         FArray3Da_size_t;
typedef  FArray3Da< std::size_t >         FArray3Da_size;
typedef  FArray3Da< float >               FArray3Da_float;
typedef  FArray3Da< double >              FArray3Da_double;
typedef  FArray3Da< long double >         FArray3Da_longdouble;
typedef  FArray3Da< char >                FArray3Da_char;
typedef  FArray3Da< unsigned char >       FArray3Da_uchar;
typedef  FArray3Da< signed char >         FArray3Da_schar;
typedef  FArray3Da< std::string >         FArray3Da_string;
typedef  FArray3Da< Fstring >             FArray3Da_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray3Da_FWD_HH
