// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#ifndef INCLUDED_ObjexxFCL_FArray3Dp_FWD_HH
#define INCLUDED_ObjexxFCL_FArray3Dp_FWD_HH


// FArray3Dp Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray3Dp;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  FArray3Dp< bool >                FArray3Dp_bool;
typedef  FArray3Dp< sbyte >                FArray3Dp_byte;
typedef  FArray3Dp< ubyte >               FArray3Dp_ubyte;
typedef  FArray3Dp< short int >           FArray3Dp_short;
typedef  FArray3Dp< int >                 FArray3Dp_int;
typedef  FArray3Dp< long int >            FArray3Dp_long;
typedef  FArray3Dp< unsigned short int >  FArray3Dp_ushort;
typedef  FArray3Dp< unsigned int >        FArray3Dp_uint;
typedef  FArray3Dp< unsigned long int >   FArray3Dp_ulong;
typedef  FArray3Dp< std::size_t >         FArray3Dp_size_t;
typedef  FArray3Dp< std::size_t >         FArray3Dp_size;
typedef  FArray3Dp< float >               FArray3Dp_float;
typedef  FArray3Dp< double >              FArray3Dp_double;
typedef  FArray3Dp< long double >         FArray3Dp_longdouble;
typedef  FArray3Dp< char >                FArray3Dp_char;
typedef  FArray3Dp< unsigned char >       FArray3Dp_uchar;
typedef  FArray3Dp< signed char >         FArray3Dp_schar;
typedef  FArray3Dp< std::string >         FArray3Dp_string;
typedef  FArray3Dp< Fstring >             FArray3Dp_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray3Dp_FWD_HH
