// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#ifndef INCLUDED_ObjexxFCL_FArray4D_FWD_HH
#define INCLUDED_ObjexxFCL_FArray4D_FWD_HH


// FArray4D Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray4D;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  FArray4D< bool >                FArray4D_bool;
typedef  FArray4D< sbyte >                FArray4D_byte;
typedef  FArray4D< ubyte >               FArray4D_ubyte;
typedef  FArray4D< short int >           FArray4D_short;
typedef  FArray4D< int >                 FArray4D_int;
typedef  FArray4D< long int >            FArray4D_long;
typedef  FArray4D< unsigned short int >  FArray4D_ushort;
typedef  FArray4D< unsigned int >        FArray4D_uint;
typedef  FArray4D< unsigned long int >   FArray4D_ulong;
typedef  FArray4D< std::size_t >         FArray4D_size_t;
typedef  FArray4D< std::size_t >         FArray4D_size;
typedef  FArray4D< float >               FArray4D_float;
typedef  FArray4D< double >              FArray4D_double;
typedef  FArray4D< long double >         FArray4D_longdouble;
typedef  FArray4D< char >                FArray4D_char;
typedef  FArray4D< unsigned char >       FArray4D_uchar;
typedef  FArray4D< signed char >         FArray4D_schar;
typedef  FArray4D< std::string >         FArray4D_string;
typedef  FArray4D< Fstring >             FArray4D_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray4D_FWD_HH
