// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#ifndef INCLUDED_ObjexxFCL_FArray4Dp_FWD_HH
#define INCLUDED_ObjexxFCL_FArray4Dp_FWD_HH


// FArray4Dp Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray4Dp;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  FArray4Dp< bool >                FArray4Dp_bool;
typedef  FArray4Dp< sbyte >                FArray4Dp_byte;
typedef  FArray4Dp< ubyte >               FArray4Dp_ubyte;
typedef  FArray4Dp< short int >           FArray4Dp_short;
typedef  FArray4Dp< int >                 FArray4Dp_int;
typedef  FArray4Dp< long int >            FArray4Dp_long;
typedef  FArray4Dp< unsigned short int >  FArray4Dp_ushort;
typedef  FArray4Dp< unsigned int >        FArray4Dp_uint;
typedef  FArray4Dp< unsigned long int >   FArray4Dp_ulong;
typedef  FArray4Dp< std::size_t >         FArray4Dp_size_t;
typedef  FArray4Dp< std::size_t >         FArray4Dp_size;
typedef  FArray4Dp< float >               FArray4Dp_float;
typedef  FArray4Dp< double >              FArray4Dp_double;
typedef  FArray4Dp< long double >         FArray4Dp_longdouble;
typedef  FArray4Dp< char >                FArray4Dp_char;
typedef  FArray4Dp< unsigned char >       FArray4Dp_uchar;
typedef  FArray4Dp< signed char >         FArray4Dp_schar;
typedef  FArray4Dp< std::string >         FArray4Dp_string;
typedef  FArray4Dp< Fstring >             FArray4Dp_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray4Dp_FWD_HH
