// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#ifndef INCLUDED_ObjexxFCL_FArray5Da_FWD_HH
#define INCLUDED_ObjexxFCL_FArray5Da_FWD_HH


// FArray5Da Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray5Da;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  FArray5Da< bool >                FArray5Da_bool;
typedef  FArray5Da< sbyte >                FArray5Da_byte;
typedef  FArray5Da< ubyte >               FArray5Da_ubyte;
typedef  FArray5Da< short int >           FArray5Da_short;
typedef  FArray5Da< int >                 FArray5Da_int;
typedef  FArray5Da< long int >            FArray5Da_long;
typedef  FArray5Da< unsigned short int >  FArray5Da_ushort;
typedef  FArray5Da< unsigned int >        FArray5Da_uint;
typedef  FArray5Da< unsigned long int >   FArray5Da_ulong;
typedef  FArray5Da< std::size_t >         FArray5Da_size_t;
typedef  FArray5Da< std::size_t >         FArray5Da_size;
typedef  FArray5Da< float >               FArray5Da_float;
typedef  FArray5Da< double >              FArray5Da_double;
typedef  FArray5Da< long double >         FArray5Da_longdouble;
typedef  FArray5Da< char >                FArray5Da_char;
typedef  FArray5Da< unsigned char >       FArray5Da_uchar;
typedef  FArray5Da< signed char >         FArray5Da_schar;
typedef  FArray5Da< std::string >         FArray5Da_string;
typedef  FArray5Da< Fstring >             FArray5Da_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray5Da_FWD_HH
