// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#ifndef INCLUDED_ObjexxFCL_FArray5Dp_FWD_HH
#define INCLUDED_ObjexxFCL_FArray5Dp_FWD_HH


// FArray5Dp Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray5Dp;
class sbyte;
class ubyte;
class Fstring;


// Types
typedef  FArray5Dp< bool >                FArray5Dp_bool;
typedef  FArray5Dp< sbyte >                FArray5Dp_byte;
typedef  FArray5Dp< ubyte >               FArray5Dp_ubyte;
typedef  FArray5Dp< short int >           FArray5Dp_short;
typedef  FArray5Dp< int >                 FArray5Dp_int;
typedef  FArray5Dp< long int >            FArray5Dp_long;
typedef  FArray5Dp< unsigned short int >  FArray5Dp_ushort;
typedef  FArray5Dp< unsigned int >        FArray5Dp_uint;
typedef  FArray5Dp< unsigned long int >   FArray5Dp_ulong;
typedef  FArray5Dp< std::size_t >         FArray5Dp_size_t;
typedef  FArray5Dp< std::size_t >         FArray5Dp_size;
typedef  FArray5Dp< float >               FArray5Dp_float;
typedef  FArray5Dp< double >              FArray5Dp_double;
typedef  FArray5Dp< long double >         FArray5Dp_longdouble;
typedef  FArray5Dp< char >                FArray5Dp_char;
typedef  FArray5Dp< unsigned char >       FArray5Dp_uchar;
typedef  FArray5Dp< signed char >         FArray5Dp_schar;
typedef  FArray5Dp< std::string >         FArray5Dp_string;
typedef  FArray5Dp< Fstring >             FArray5Dp_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray5Dp_FWD_HH
