// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#ifndef INCLUDED_ObjexxFCL_FArraySection_HH
#define INCLUDED_ObjexxFCL_FArraySection_HH


// FArraySection: Fortran-Compatible Array Section Proxy
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com

#include "platform/types.hh"

// ObjexxFCL Headers
#include <ObjexxFCL/FArraySection.fwd.hh>

// C++ Standard Library Headers
#include <cstddef>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArrayB;


/// @brief FArraySection: Fortran-Compatible Array Section Proxy
template< typename T >
class FArraySection
{


private: // Friend


	friend class FArrayB< T >;


public: // Types


	// STL style
	typedef  T  value_type;
	typedef  T &  reference;
	typedef  T const &  const_reference;
	typedef  T *  pointer;
	typedef  T const *  const_pointer;
	typedef  platform::Size size_type;
	typedef  std::ptrdiff_t  difference_type;

	// C++ style
	typedef  T  Value;
	typedef  T &  Reference;
	typedef  T const &  ConstReference;
	typedef  T *  Pointer;
	typedef  T const *  ConstPointer;
	typedef platform::Size Size;
	typedef  std::ptrdiff_t  Difference;


public: // Creation


	/// @brief Copy Constructor
	inline
	FArraySection( FArraySection const & s ) :
		size_( s.size_ ),
		array_( s.array_ )
	{}


	/// @brief Size + Pointer Constructor
	inline
	FArraySection( size_type const size_a, value_type * array_a ) :
		size_( size_a ),
		array_( array_a )
	{}


	/// @brief Destructor
	inline
	~FArraySection()
	{}


public: // Assignment


	/// @brief Copy Assignment
	inline
	FArraySection &
	operator =( FArraySection const & s )
	{
		if ( this != &s ) {
			size_ = s.size_;
			array_ = s.array_;
		}
		return *this;
	}


public: // Inspector


	/// @brief Size
	inline
	size_type
	size() const
	{
		return size_;
	}


private: // Inspector


	/// @brief array
	inline
	pointer
	array() const
	{
		return array_;
	}


private: // Data


	/// @brief Size of data array
	size_type size_;

	/// @brief Pointer (non-owning) to data array
	pointer array_;


}; // FArraySection


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArraySection_HH
