// Observer: Combined Subject + Observer Abstract Base Class
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.


// ObjexxFCL Headers
#include <ObjexxFCL/Observer.hh>
#include <ObjexxFCL/internal/ObserverMediator.hh>


namespace ObjexxFCL {


// Observer: Combined Subject + Observer Abstract Base Class


	/// @brief Notify Observers That This Subject Has Changed
	void
	Observer::notify() const
	{
		if ( has_observer() ) internal::ObserverMediator::notify( *this );
	}


	/// @brief Acyclic After Adding an Observer of This Subject?
	bool
	Observer::acyclic( Observer & observer ) const
	{
		return internal::ObserverMediator::acyclic( *this, observer );
	}


// Observer


} // namespace ObjexxFCL
