// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#ifndef INCLUDED_ObjexxFCL_array_iterator_HH
#define INCLUDED_ObjexxFCL_array_iterator_HH


// C Array Iterator Functions
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>


namespace ObjexxFCL {


/// @brief Begin Iterator for C Array
template < typename T, std::size_t N >
inline
T *
begin( T (&array)[N] )
{
	return array + 0;
}


/// @brief End Iterator for C Array
template < typename T, std::size_t N >
inline
T *
end( T (&array)[N] )
{
	return array + N;
}


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_array_iterator_HH
