// Character Functions
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.


// ObjexxFCL Headers
#include <ObjexxFCL/char.functions.hh>

// C++ Standard Library Headers
#include <cstddef>
#include <cctype>
#include <cstring>


namespace ObjexxFCL {


// Constants
char const SPACE( ' ' );


// Predicate


/// @brief char == char Case-Optionally?
bool
equal( char const c, char const d, bool const exact_case )
{
	if ( exact_case ) {
		return ( c == d );
	} else {
		return ( std::tolower( c ) == std::tolower( d ) );
	}
}


/// @brief char == char Case-Insensitively
bool
equali( char const c, char const d )
{
	return ( std::tolower( c ) == std::tolower( d ) );
}


/// @brief Character is Blank?
bool
is_blank( char const c )
{
	return ( c == SPACE );
}


/// @brief Character is Not Blank?
bool
not_blank( char const c )
{
	return ( c != SPACE );
}


/// @brief Character is in a string?
bool
is_any_of( char const c, std::string const & s )
{
	return ( s.find( c ) != std::string::npos );
}


/// @brief Character is in a cstring?
bool
is_any_of( char const c, c_cstring const s )
{
	for ( std::size_t i = 0, e = std::strlen( s ); i < e; ++i ) {
		if ( c == s[ i ] ) return true;
	}
	return false; // No matches
}


// Modifier


/// @brief Lowercase a Character
char &
lowercase( char & c )
{
	c = std::tolower( c );
	return c;
}


/// @brief Uppercase a Character
char &
uppercase( char & c )
{
	c = std::toupper( c );
	return c;
}


// Generator


/// @brief Lowercased Copy of a Character
char
lowercased( char const c )
{
	return std::tolower( c );
}


/// @brief Uppercased Copy of a Character
char
uppercased( char const c )
{
	return std::toupper( c );
}


} // namespace ObjexxFCL
