// Fortran-Compatible Formatted Input Functions and Classes
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.


// ObjexxFCL Headers
#include <ObjexxFCL/formatted.i.hh>
#include <ObjexxFCL/Fstring.hh>


namespace ObjexxFCL {
namespace fmt {


// Bite Explicit Specializations


	/// @brief Assign Stream Bite to Value: Fstring Specialization
	template<>
	void
	Bite< Fstring >::assign( std::stringstream & ss ) const
	{
		t_ = ss.str();
	}


// Bite Makers


/// @brief Fstring Bite Maker: Take Length of Fstring
Bite< Fstring >
bite( Fstring & t )
{
	return Bite< Fstring >( t.length(), t );
}


} // namespace fmt
} // namespace ObjexxFCL
