// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   rosetta/benchmark/LigandDock.bench.hh
///
/// @brief Dock the ligand in the 7cpa complex.
/// Use all options (flexible ligand, flexible backbone)
/// @author Gordon Lemmon

#include <protocols/jobdist/standard_mains.hh>

#include "benchmark.hh"
#include "init_util.hh"
#include "core/io/pdb/pose_io.hh"
#include "core/pose/Pose.hh"
#include "protocols/ligand_docking/LigandDockProtocol.hh"
#include "core/options/option.hh"
#include <core/options/keys/in.OptionKeys.gen.hh>

class LigandDockBenchmark : public Benchmark
{
public:
	LigandDockBenchmark(std::string name) : Benchmark(name) {};

	core::pose::Pose ligand_dock_pose;

	virtual void setUp() {
		core::options::option.load_options_from_file("ligand_dock/ligand_dock_flags.txt");

		std::string pdb_file_name= core::options::option[ core::options::OptionKeys::in::file::s ]()[1];
		core::io::pdb::pose_from_pdb(ligand_dock_pose, pdb_file_name);
	};

	virtual void run(int scaleFactor) {
		protocols::ligand_docking::LigandDockProtocol dock_protocol;
		for(int i=0; i<scaleFactor; i++) {
			dock_protocol.apply(ligand_dock_pose);
		}
	};

	virtual void tearDown() {};
};
