// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   rosetta/benchmark/score.bench.cc
///
/// @brief  Scoring benchmark
/// @author Sergey Lyskov

#include "benchmark.hh"

#include <core/pose/Pose.hh>
#include <core/io/pdb/pose_io.hh>
#include <core/scoring/ScoreFunction.hh>

using namespace core;

class ScoreBenchmark : public Benchmark
{
public:
	pose::Pose pose;

	ScoreBenchmark(std::string name) : Benchmark(name) {};

	virtual void setUp() {
		io::pdb::pose_from_pdb(pose, "test_in.pdb");
	};

	virtual void run(int scaleFactor) {
		scoring::ScoreFunction scorefxn;
		for(int i=0; i<45000*scaleFactor; i++) {
			scorefxn(pose);
			pose.energies().clear();
		}
	};

	virtual void tearDown() {};
};
