// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file devel/ProteinInterfaceDesign/dock_design_parser.cc
/// @brief Parses an xml file that contains information on docking moves and filters to be applied by
//// conditional_jobdist_mover
/// @author Sarel Fleishman (sarelf@u.washington.edu)

// Project Headers
#include <protocols/ProteinInterfaceDesign/conditional_jobdist_mover.hh>
#include <protocols/viewer/viewers.hh>
#include <core/options/option_macros.hh>
#include <core/types.hh>
#include <protocols/abinitio/ClassicAbinitio.hh>

#include <core/io/database/open.hh>

#include <core/options/util.hh>
#include <core/init.hh>
#include <core/options/option.hh>

// Utility Headers

// Unit Headers
#include <protocols/ProteinInterfaceDesign/setup_dockdesign_mover.hh>

#include <core/options/keys/parser.OptionKeys.gen.hh>
#include <core/options/keys/in.OptionKeys.gen.hh>
#include <core/options/keys/out.OptionKeys.gen.hh>
#include <core/options/keys/parser.OptionKeys.gen.hh>

// C++ headers

void*
my_main( void *)
{
	protocols::ProteinInterfaceDesign::main_conditional_mover( protocols::ProteinInterfaceDesign::setup_dockdesign_mover );
	return 0 ;
}

/// @details dock_design_scripting provides an xml-based scripting capability
/// to run rosetta movers and filters defined in a text file provided by the
/// user. A full documentation of dock_design_scripting is available at:
/// manual_doxygen/applications/app_dock_design.dox
int
main( int argc, char * argv [] )
{
	using namespace core::options;
	using namespace core::options::OptionKeys;

  protocols::abinitio::ClassicAbinitio::register_options();
	option.add_relevant( parser::view );
	option.add_relevant( parser::ntrials );
	option.add_relevant( parser::protocol );
	option.add_relevant( parser::patchdock );
	option.add_relevant( parser::patchdock_random_entry );
	option.add_relevant( in::file::silent );
	option.add_relevant( in::file::silent_struct_type );
	option.add_relevant( in::file::fold_tree );
	option.add_relevant( out::file::silent );
	option.add_relevant( out::file::silent_struct_type );

	// setup random numbers and options
	core::init(argc, argv);
	bool const view( option[ parser::view ] );

	if( view )
	protocols::viewer::viewer_main( my_main );
	else
		protocols::ProteinInterfaceDesign::main_conditional_mover( protocols::ProteinInterfaceDesign::setup_dockdesign_mover );
	return 1;
}

