// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file Monica Berrondo October 22 2007
/// @brief


// libRosetta headers
#include <protocols/docking/DockingProtocol.hh>

#include <core/pose/Pose.hh>

#include <numeric/random/random.hh>

#include <protocols/jobdist/standard_mains.hh>

#include <protocols/moves/Mover.hh>
#include <protocols/viewer/viewers.hh>

#include <ObjexxFCL/formatted.o.hh>

#include <core/init.hh>

// C++ headers
//#include <cstdlib>
#include <fstream>
#include <iostream>
#include <string>

#include <core/util/Tracer.hh>

// option key includes

#include <core/options/keys/docking.OptionKeys.gen.hh>


using core::util::T;
using core::util::Error;
using core::util::Warning;

using namespace core;

void*
my_main( void* ) {
	using namespace protocols;
	using namespace protocols::moves;

	core::pose::PoseOP pose = new core::pose::Pose();
	core::io::pdb::pose_from_pdb( *pose, "dock.pdb" );
	MoverOP dock = new docking::DockingProtocol(1);
	dock->set_input_pose( pose );
	dock->set_native_pose( pose );
	dock->apply( *pose );
	return 0;
}

int
main( int argc, char * argv [] )
{
	using namespace protocols;
	using namespace protocols::jobdist;
	using namespace protocols::moves;

	// initialize core
	init(argc, argv);

	if (options::option[ options::OptionKeys::docking::view ]()) {
		protocols::viewer::viewer_main( my_main );
	} else {
		MoverOP dock = new docking::DockingProtocol(1);
		protocols::jobdist::main_plain_mover(argc, argv, *dock);
	}

	std::cout << "Done! -------------------------------\n";
}

