// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file Mike Tyka & Phil bradley
/// @brief


// libRosetta headers
#include <protocols/idealize/idealize.hh>
#include <protocols/jobdist/standard_mains.hh>
#include <core/options/option.hh>
#include <core/init.hh>



// C++ headers
//#include <cstdlib>
#include <fstream>
#include <iostream>
#include <string>

using namespace core;

#include <core/options/option_macros.hh>

OPT_KEY( Real, atom_pair_constraint_weight )
OPT_KEY( Real, coordinate_constraint_weight )
OPT_KEY( Boolean, fast )

void
register_options() {
	using namespace core::options;
	using namespace core::options::OptionKeys;
	NEW_OPT( atom_pair_constraint_weight, "atompair constraint weight", 0.0 );
	NEW_OPT( coordinate_constraint_weight, "coordinate constraint weight", 0.0 );
	NEW_OPT( fast, "fast protocol", false );
}

int
main( int argc, char * argv [] )
{
	using namespace protocols;
	using namespace protocols::jobdist;
	using namespace protocols::moves;
	using core::options::option;
	using namespace core::options::OptionKeys;


	register_options();
	init(argc, argv);

	protocols::idealize::IdealizeMover idealizer;

	// set some options
	if ( option[ coordinate_constraint_weight ].user() ) {
		idealizer.coordinate_constraint_weight( option[ coordinate_constraint_weight ]() ) ;
	}
	if ( option[ atom_pair_constraint_weight ].user() ) {
		idealizer.atom_pair_constraint_weight( option[ atom_pair_constraint_weight ]() );
	}
	idealizer.fast( option[ fast ]() );

	main_plain_mover(argc, argv, idealizer);

	return 0;
}

