// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief


// libRosetta headers

#include <protocols/jobdist/standard_mains.hh>
#include <protocols/relax_protocols.hh>
#include <core/scoring/constraints/util.hh>
#include <core/options/option.hh>
#include <core/options/after_opts.hh>

#include <core/scoring/ScoreFunctionFactory.hh>
#include <core/init.hh>
#include <core/options/option.hh>

// C++ headers
//#include <cstdlib>
#include <fstream>
#include <iostream>
#include <string>

//silly using/typedef


#include <core/util/Tracer.hh>

// option key includes

#include <core/options/keys/relax.OptionKeys.gen.hh>
#include <core/options/keys/in.OptionKeys.gen.hh>


using core::util::T;
using core::util::Error;
using core::util::Warning;


using namespace core;
using namespace protocols;

using utility::vector1;



///////////////////////////////////////////////////////////////////////////////

int
main( int argc, char * argv [] )
{
	using namespace protocols::jobdist;
	using namespace protocols::moves;
	using namespace scoring;
	using namespace core::options;


	relax::ClassicRelax::register_options();
	relax::SimpleMultiRelax::register_options();
	register_options_universal_main();
	option.add_relevant( OptionKeys::in::file::fullatom );
	option.add_relevant( OptionKeys::relax::fast );
	core::init(argc, argv);

	return relax::Relax_main( false );
}
