// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file Oliver Lange
/// @brief


// libRosetta headers
#include <protocols/jd2/JobDistributor.hh>

#include <protocols/moves/Mover.hh>
#include <core/util/Tracer.hh>
#include <core/init.hh>
#include <core/scoring/Energies.hh>
#include <core/scoring/ScoreFunction.hh>
#include <core/scoring/ScoreFunctionFactory.hh>
#include <core/options/option.hh>

#include <protocols/topology_broker/TopologyBroker.hh>
#include <protocols/topology_broker/util.hh>
#include <utility/excn/Exceptions.hh>
#include <utility/exit.hh>

// C++ headers
//#include <cstdlib>
#include <fstream>
#include <iostream>
#include <string>

// option key includes
#include <core/options/keys/broker.OptionKeys.gen.hh>



static core::util::Tracer TR("main");

using namespace protocols::moves;
using namespace core::scoring;
// using namespace core::options;
// using namespace core::options::OptionKeys;



class MyScoreMover : public Mover {
public:
	MyScoreMover();

	virtual void apply( core::pose::Pose& pose );

	virtual MoverOP clone() const {
		return new MyScoreMover( *this );
	}

	virtual	MoverOP	fresh_instance() const {
		return new MyScoreMover;
	}

private:
	core::scoring::ScoreFunctionOP sfxn_;
};

MyScoreMover::MyScoreMover() {
	// get scorefxn and add constraints if defined
	sfxn_ = core::scoring::getScoreFunction();
	// 	if( option[ in::file::fullatom ]() ) {
	// 		core::scoring::constraints::add_fa_constraints_from_cmdline_to_scorefxn( *sfxn_ );
	// 	} else {
	// 		core::scoring::constraints::add_constraints_from_cmdline_to_scorefxn( *sfxn_ );
	// 	}

	// 	// now add density scores from cmd line
	// 	if ( option[ edensity::mapfile ].user() ) {
	// 		core::scoring::electron_density::add_dens_scores_from_cmdline_to_scorefxn( *sfxn_ );
	// 	}
}

void MyScoreMover::apply( core::pose::Pose& pose ) {
	pose.energies().clear();
	pose.data().clear();
	(*sfxn_)( pose );
}

int
main( int argc, char * argv [] )
{
	using namespace protocols;
	using namespace protocols::jd2;

	using namespace core::options;
	using namespace core::options::OptionKeys;
	using namespace core;

	// scoring should by default not produce output files - that's so annoying
	// unless of coures the user insists.

	// initialize core
	core::init(argc, argv);


	//The following lines are to ensure one can rescore the pcs energy term (that uses TopologyClaimer)
	if( option[ broker::setup ].user() ){
		bool do_I_need_fragments (false);
		protocols::topology_broker::TopologyBrokerOP top_bro_OP = new  topology_broker::TopologyBroker();
		try{
			add_claims_from_file(*top_bro_OP,  option[ broker::setup ](), do_I_need_fragments);
		}
		catch ( utility::excn::EXCN_Exception &excn )  {
			excn.show( TR.Error );
			utility_exit();
		}
	}


	protocols::jd2::JobDistributor::get_instance()->go( new MyScoreMover );

	return 0;
}

